/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.ricmc.betterblockz.block.ModBlocks;
import org.jetbrains.annotations.NotNull;

public class BetterBuilderItem
extends Item {
    public BetterBuilderItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos clickedPos = context.getClickedPos();
        Direction face = context.getClickedFace();
        BlockPos basePos = clickedPos.relative(face);
        Direction dir = context.getHorizontalDirection();
        int row = 0;
        int size = 7;
        int gap = 1;
        if (player.isShiftKeyDown()) {
            for (Map.Entry<String, DeferredBlock<?>[]> entry : ModBlocks.VARIANTS.entrySet()) {
                DeferredBlock<?>[] variants = entry.getValue();
                for (int i = 0; i < variants.length; ++i) {
                    int ox = 0;
                    int oz = 0;
                    switch (dir) {
                        case NORTH: {
                            ox = i * size;
                            oz = -row;
                            break;
                        }
                        case SOUTH: {
                            ox = -i * size;
                            oz = row;
                            break;
                        }
                        case WEST: {
                            ox = -row;
                            oz = -i * size;
                            break;
                        }
                        case EAST: {
                            ox = row;
                            oz = i * size;
                        }
                    }
                    BlockPos variantOrigin = basePos.offset(ox, 0, oz);
                    for (int dx = 0; dx < size; ++dx) {
                        for (int dz = 0; dz < size; ++dz) {
                            int xOff = 0;
                            int zOff = 0;
                            switch (dir) {
                                case NORTH: {
                                    xOff = dx;
                                    zOff = -dz;
                                    break;
                                }
                                case SOUTH: {
                                    xOff = -dx;
                                    zOff = dz;
                                    break;
                                }
                                case WEST: {
                                    xOff = -dz;
                                    zOff = -dx;
                                    break;
                                }
                                case EAST: {
                                    xOff = dz;
                                    zOff = dx;
                                }
                            }
                            BlockPos placePos = variantOrigin.offset(xOff, 0, zOff);
                            if (!level.isEmptyBlock(placePos)) continue;
                            level.setBlock(placePos, ((Block)variants[i].get()).defaultBlockState(), 3);
                        }
                    }
                }
                row += size + gap;
            }
            for (List list : List.of(ModBlocks.CYBERLIGHT_THIN, ModBlocks.CYBERLIGHT_THIN_ALT)) {
                for (int i = 0; i < list.size(); ++i) {
                    int ox = 0;
                    int oz = 0;
                    switch (dir) {
                        case NORTH: {
                            ox = i * size;
                            oz = -row;
                            break;
                        }
                        case SOUTH: {
                            ox = -i * size;
                            oz = row;
                            break;
                        }
                        case WEST: {
                            ox = -row;
                            oz = -i * size;
                            break;
                        }
                        case EAST: {
                            ox = row;
                            oz = i * size;
                        }
                    }
                    BlockPos variantOrigin = basePos.offset(ox, 0, oz);
                    for (int dx = 0; dx < size; ++dx) {
                        for (int dz = 0; dz < size; ++dz) {
                            int xOff = 0;
                            int zOff = 0;
                            switch (dir) {
                                case NORTH: {
                                    xOff = dx;
                                    zOff = -dz;
                                    break;
                                }
                                case SOUTH: {
                                    xOff = -dx;
                                    zOff = dz;
                                    break;
                                }
                                case WEST: {
                                    xOff = -dz;
                                    zOff = -dx;
                                    break;
                                }
                                case EAST: {
                                    xOff = dz;
                                    zOff = dx;
                                }
                            }
                            BlockPos placePos = variantOrigin.offset(xOff, 0, zOff);
                            if (!level.isEmptyBlock(placePos)) continue;
                            level.setBlock(placePos, ((Block)((DeferredBlock)list.get(i)).get()).defaultBlockState(), 3);
                        }
                    }
                }
                row += size + gap;
            }
        } else {
            for (Map.Entry<String, DeferredBlock<?>[]> entry : ModBlocks.VARIANTS.entrySet()) {
                DeferredBlock<?>[] variants = entry.getValue();
                for (int i = 0; i < variants.length; ++i) {
                    int ox = 0;
                    int oz = 0;
                    switch (dir) {
                        case NORTH: {
                            ox = i;
                            oz = -row;
                            break;
                        }
                        case SOUTH: {
                            ox = -i;
                            oz = row;
                            break;
                        }
                        case WEST: {
                            ox = -row;
                            oz = -i;
                            break;
                        }
                        case EAST: {
                            ox = row;
                            oz = i;
                        }
                    }
                    BlockPos placePos = basePos.offset(ox, 0, oz);
                    if (!level.isEmptyBlock(placePos)) continue;
                    level.setBlock(placePos, ((Block)variants[i].get()).defaultBlockState(), 3);
                }
                row += 2;
            }
            for (List list : List.of(ModBlocks.CYBERLIGHT_THIN, ModBlocks.CYBERLIGHT_THIN_ALT)) {
                for (int i = 0; i < list.size(); ++i) {
                    int ox = 0;
                    int oz = 0;
                    switch (dir) {
                        case NORTH: {
                            ox = i;
                            oz = -row;
                            break;
                        }
                        case SOUTH: {
                            ox = -i;
                            oz = row;
                            break;
                        }
                        case WEST: {
                            ox = -row;
                            oz = -i;
                            break;
                        }
                        case EAST: {
                            ox = row;
                            oz = i;
                        }
                    }
                    BlockPos placePos = basePos.offset(ox, 0, oz);
                    if (!level.isEmptyBlock(placePos)) continue;
                    level.setBlock(placePos, ((Block)((DeferredBlock)list.get(i)).get()).defaultBlockState(), 3);
                }
                row += 2;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        tooltip.add((Component)Component.literal((String)("Mode: " + (Screen.hasShiftDown() ? "Sneak: 5x5" : "1 Block"))));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

