/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.block.custom.LightPanelBlock;
import net.ricmc.betterblockz.block.custom.WallOrFloorLightBlock;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

public class BlockRandomizerItem
extends Item {
    private final Random random = new Random();
    private static final List<char[][]> SYMBOL_PATTERNS = List.of(new char[][][]{new char[][]{{'a', 'b', 'a'}, {'c', 'c', 'c'}, {'b', 'a', 'b'}}, new char[][]{{'a', 'a', 'a'}, {'b', 'b', 'b'}, {'c', 'c', 'c'}}, new char[][]{{'a', 'b', 'c'}, {'a', 'b', 'c'}, {'a', 'b', 'c'}}, new char[][]{{'a', 'b', 'a'}, {'b', 'c', 'b'}, {'a', 'b', 'a'}}, new char[][]{{'a', 'b', 'c'}, {'c', 'b', 'a'}, {'a', 'b', 'c'}}, new char[][]{{'a', 'c', 'a'}, {'b', 'b', 'b'}, {'a', 'c', 'a'}}, new char[][]{{'a', 'b', 'c'}, {'b', 'c', 'a'}, {'c', 'a', 'b'}}, new char[][]{{'a', 'a', 'b'}, {'c', 'c', 'b'}, {'a', 'a', 'b'}}, new char[][]{{'a', 'b', 'a'}, {'c', 'a', 'c'}, {'a', 'b', 'a'}}, new char[][]{{'a', 'b', 'c'}, {'a', 'a', 'a'}, {'c', 'b', 'a'}}, new char[][]{{'a', 'b', 'c'}, {'b', 'c', 'a'}, {'c', 'a', 'b'}}, new char[][]{{'a', 'b', 'a'}, {'b', 'a', 'b'}, {'a', 'b', 'a'}}, new char[][]{{'a', 'a', 'a'}, {'a', 'b', 'a'}, {'a', 'a', 'a'}}, new char[][]{{'a', 'b', 'c'}, {'c', 'a', 'b'}, {'b', 'c', 'a'}}, new char[][]{{'b', 'a', 'b'}, {'a', 'c', 'a'}, {'b', 'a', 'b'}}, new char[][]{{'a', 'b', 'c'}, {'b', 'a', 'c'}, {'c', 'b', 'a'}}, new char[][]{{'a', 'b', 'a'}, {'a', 'b', 'a'}, {'a', 'b', 'a'}}, new char[][]{{'a', 'a', 'a'}, {'b', 'b', 'b'}, {'a', 'a', 'a'}}, new char[][]{{'a', 'b', 'a'}, {'b', 'a', 'b'}, {'a', 'b', 'a'}}, new char[][]{{'a', 'a', 'b'}, {'a', 'b', 'a'}, {'b', 'a', 'a'}}, new char[][]{{'a', 'b', 'b'}, {'b', 'a', 'a'}, {'a', 'b', 'b'}}, new char[][]{{'a', 'a', 'a'}, {'a', 'b', 'a'}, {'a', 'a', 'a'}}, new char[][]{{'a', 'b', 'a'}, {'a', 'a', 'a'}, {'a', 'b', 'a'}}, new char[][]{{'a', 'b', 'a'}, {'b', 'b', 'b'}, {'a', 'b', 'a'}}, new char[][]{{'a', 'a', 'b'}, {'b', 'b', 'a'}, {'a', 'a', 'b'}}});

    public BlockRandomizerItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos startPos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(1);
        Block clickedBlock = level.getBlockState(startPos).getBlock();
        if (!level.isClientSide()) {
            switch (mode) {
                case 1: {
                    this.applyPatternFloodFill(level, startPos, clickedBlock, context.getClickedFace(), 2);
                    break;
                }
                case 2: {
                    this.applyPatternFloodFill(level, startPos, clickedBlock, context.getClickedFace(), 3);
                    break;
                }
                case 3: {
                    Direction.Axis chosenAxis = null;
                    if (clickedBlock.defaultBlockState().hasProperty((Property)BlockStateProperties.AXIS)) {
                        Direction.Axis[] axes = Direction.Axis.values();
                        chosenAxis = axes[this.random.nextInt(axes.length)];
                    }
                    Direction.Axis finalAxis = chosenAxis;
                    this.applyFloodFill(level, startPos, clickedBlock, context.getClickedFace(), pos -> this.replaceWithRandomVariant(level, (BlockPos)pos, finalAxis), finalAxis);
                    break;
                }
                case 4: {
                    this.applyFloodFill(level, startPos, clickedBlock, context.getClickedFace(), pos -> this.resetToBaseVariant(level, (BlockPos)pos), Direction.Axis.Y);
                }
            }
            level.playSound(null, startPos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 1.0f, 1.5f);
        }
        return InteractionResult.SUCCESS;
    }

    private void applyFloodFill(Level level, BlockPos startPos, Block targetBlock, Direction face, Consumer<BlockPos> replacer, @Nullable Direction.Axis fixedAxis) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        String baseName = this.getBaseName(targetBlock);
        List<BlockPos> offsets = face == Direction.UP || face == Direction.DOWN ? List.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1)) : (face.getAxis() == Direction.Axis.X ? List.of(new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(0, 1, 1), new BlockPos(0, 1, -1), new BlockPos(0, -1, 1), new BlockPos(0, -1, -1)) : List.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(1, 1, 0), new BlockPos(1, -1, 0), new BlockPos(-1, 1, 0), new BlockPos(-1, -1, 0)));
        while (!queue.isEmpty() && visited.size() < 1000) {
            BlockPos current = (BlockPos)queue.poll();
            Block blockAtPos = level.getBlockState(current).getBlock();
            if (!this.getBaseName(blockAtPos).equals(baseName)) continue;
            boolean blocked = false;
            if (face == Direction.UP) {
                blocked = !level.getBlockState(current.above()).isAir();
            } else if (face == Direction.DOWN) {
                blocked = !level.getBlockState(current.below()).isAir();
            } else {
                BlockPos inFront = current.relative(face);
                boolean bl = blocked = !level.getBlockState(inFront).isAir();
            }
            if (blocked) continue;
            replacer.accept(current);
            for (BlockPos offset : offsets) {
                Block neighborBlock;
                BlockPos neighbor = current.offset((Vec3i)offset);
                if (visited.contains(neighbor) || !this.getBaseName(neighborBlock = level.getBlockState(neighbor).getBlock()).equals(baseName)) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
    }

    private void replaceWithRandomVariant(Level level, BlockPos pos, @Nullable Direction.Axis fixedAxis) {
        BlockState currentState = level.getBlockState(pos);
        Block clickedBlock = currentState.getBlock();
        List variants = ModBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(b -> this.getBaseName((Block)b).equals(this.getBaseName(clickedBlock))).collect(Collectors.toList());
        if (variants.isEmpty()) {
            return;
        }
        Block nextBlock = (Block)variants.get(this.random.nextInt(variants.size()));
        this.setBlockPreserveFacing(level, pos, currentState, nextBlock, fixedAxis);
    }

    private void resetToBaseVariant(Level level, BlockPos pos) {
        BlockState currentState = level.getBlockState(pos);
        Block clickedBlock = currentState.getBlock();
        List variants = ModBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(b -> this.getBaseName((Block)b).equals(this.getBaseName(clickedBlock))).collect(Collectors.toList());
        variants.stream().filter(b -> BuiltInRegistries.BLOCK.getKey(b).getPath().endsWith("_0")).findFirst().ifPresent(baseVariant -> this.setBlockPreserveFacing(level, pos, currentState, (Block)baseVariant, Direction.Axis.Y));
    }

    private void applyPatternFloodFill(Level level, BlockPos startPos, Block clickedBlock, Direction face, int variantCount) {
        List variants = ModBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(b -> this.getBaseName((Block)b).equals(this.getBaseName(clickedBlock))).sorted(Comparator.comparingInt(this::extractIndex)).collect(Collectors.toList());
        if (variants.size() < variantCount) {
            return;
        }
        List eligiblePatterns = SYMBOL_PATTERNS.stream().filter(p -> {
            HashSet<Character> syms = new HashSet<Character>();
            char[][] cArray = p;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                char[] row;
                for (char c : row = cArray[i]) {
                    syms.add(Character.valueOf(c));
                }
            }
            return syms.size() == variantCount;
        }).collect(Collectors.toList());
        if (eligiblePatterns.isEmpty()) {
            return;
        }
        char[][] chosenPattern = (char[][])eligiblePatterns.get(this.random.nextInt(eligiblePatterns.size()));
        HashSet<Character> symbols = new HashSet<Character>();
        char[][] cArray = chosenPattern;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char[] row;
            for (char c : row = cArray[i]) {
                symbols.add(Character.valueOf(c));
            }
        }
        List symbolList = symbols.stream().sorted().toList();
        List<Object> selected = new ArrayList(variants);
        Collections.shuffle(selected, this.random);
        selected = selected.subList(0, variantCount);
        HashMap<Character, Block> mapping = new HashMap<Character, Block>();
        for (int j = 0; j < variantCount; ++j) {
            mapping.put((Character)symbolList.get(j), (Block)selected.get(j));
        }
        Direction.Axis chosenAxis = null;
        if (clickedBlock.defaultBlockState().hasProperty((Property)BlockStateProperties.AXIS)) {
            Direction.Axis[] axes = Direction.Axis.values();
            chosenAxis = axes[this.random.nextInt(axes.length)];
        }
        Direction.Axis finalAxis = chosenAxis;
        this.applyFloodFill(level, startPos, clickedBlock, face, pos -> this.replaceWithSymbolPattern(level, (BlockPos)pos, startPos, chosenPattern, (Map<Character, Block>)mapping, finalAxis, face), finalAxis);
    }

    private void replaceWithSymbolPattern(Level level, BlockPos pos, BlockPos startPos, char[][] pattern, Map<Character, Block> mapping, @Nullable Direction.Axis fixedAxis, Direction face) {
        int col;
        int row;
        int dx = pos.getX() - startPos.getX();
        int dy = pos.getY() - startPos.getY();
        int dz = pos.getZ() - startPos.getZ();
        if (face == Direction.UP || face == Direction.DOWN) {
            row = Math.floorMod(dz, pattern.length);
            col = Math.floorMod(dx, pattern[row].length);
        } else if (face.getAxis() == Direction.Axis.X) {
            row = Math.floorMod(dy, pattern.length);
            col = Math.floorMod(dz, pattern[row].length);
        } else {
            row = Math.floorMod(dy, pattern.length);
            col = Math.floorMod(dx, pattern[row].length);
        }
        char symbol = pattern[row][col];
        Block nextBlock = mapping.get(Character.valueOf(symbol));
        if (nextBlock != null) {
            this.setBlockPreserveFacing(level, pos, level.getBlockState(pos), nextBlock, fixedAxis);
        }
    }

    private void setBlockPreserveFacing(Level level, BlockPos pos, BlockState currentState, Block nextBlock, @Nullable Direction.Axis fixedAxis) {
        BlockState newState = nextBlock.defaultBlockState();
        if (fixedAxis != null && newState.hasProperty((Property)BlockStateProperties.AXIS)) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.AXIS, (Comparable)fixedAxis);
        } else if (currentState.getBlock() instanceof WallOrFloorLightBlock && newState.hasProperty((Property)WallOrFloorLightBlock.FACING)) {
            newState = (BlockState)newState.setValue((Property)WallOrFloorLightBlock.FACING, (Comparable)((Direction)currentState.getValue((Property)WallOrFloorLightBlock.FACING)));
        } else if (currentState.getBlock() instanceof LightPanelBlock && newState.hasProperty((Property)LightPanelBlock.FACING)) {
            newState = (BlockState)newState.setValue((Property)LightPanelBlock.FACING, (Comparable)((Direction)currentState.getValue((Property)LightPanelBlock.FACING)));
        } else {
            for (Property prop : currentState.getProperties()) {
                DirectionProperty dirProp;
                if (!prop.getName().equals("facing") || !(prop instanceof DirectionProperty) || !newState.hasProperty((Property)(dirProp = (DirectionProperty)prop))) continue;
                newState = (BlockState)newState.setValue((Property)dirProp, (Comparable)((Direction)currentState.getValue((Property)dirProp)));
            }
        }
        level.setBlockAndUpdate(pos, newState);
    }

    private String getBaseName(Block block) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        String path = key.getPath();
        int underscore = path.lastIndexOf("_");
        return underscore != -1 ? path.substring(0, underscore) : path;
    }

    private int extractIndex(Block block) {
        String path = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        int underscore = path.lastIndexOf("_");
        if (underscore != -1) {
            try {
                return Integer.parseInt(path.substring(underscore + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MAX_VALUE;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isShiftKeyDown()) {
            int currentMode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(1);
            int nextMode = currentMode % 4 + 1;
            stack.set(ModDataComponents.BUILDER_MODE, (Object)nextMode);
            String msg = switch (nextMode) {
                case 1 -> "Pattern (2 variants)";
                case 2 -> "Pattern (3 variants)";
                case 3 -> "Random";
                case 4 -> "Reset";
                default -> "";
            };
            player.displayClientMessage((Component)Component.literal((String)msg), true);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line1")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line2")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

