/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

public class CheckeredBuilderItem
extends Item {
    private static final int SIZE = 7;
    private static final int MODE_CHECKERED = 0;
    private static final int MODE_RANDOM = 1;

    public CheckeredBuilderItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player.isShiftKeyDown()) {
            Integer current = (Integer)stack.get(ModDataComponents.BUILDER_MODE);
            int next = current == null || current == 0 ? 1 : 0;
            stack.set(ModDataComponents.BUILDER_MODE, (Object)next);
            String modeName = next == 0 ? "Checkered" : "Random Pattern";
            player.displayClientMessage((Component)Component.literal((String)("Mode set to: " + modeName)), true);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos clickedPos = context.getClickedPos();
        if (level.isClientSide || player == null) {
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            Block clickedBlock = level.getBlockState(clickedPos).getBlock();
            stack.set(ModDataComponents.STORED_BLOCK, (Object)BuiltInRegistries.BLOCK.getKey((Object)clickedBlock));
            player.displayClientMessage((Component)Component.literal((String)("Saved block: " + clickedBlock.getName().getString())), true);
            level.playSound(null, clickedPos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        ResourceLocation savedId = (ResourceLocation)stack.get(ModDataComponents.STORED_BLOCK);
        if (savedId == null) {
            player.displayClientMessage((Component)Component.literal((String)"Sneak + Right-Click a block first to save it!"), true);
            return InteractionResult.FAIL;
        }
        Block baseBlock = (Block)BuiltInRegistries.BLOCK.get(savedId);
        if (baseBlock == null) {
            return InteractionResult.FAIL;
        }
        List<Block> variants = this.getVariantGroup(baseBlock);
        if (variants.size() < 2) {
            player.displayClientMessage((Component)Component.literal((String)"Not supported!"), true);
            return InteractionResult.FAIL;
        }
        Random rand = new Random();
        int mode = this.getMode(stack);
        Direction face = context.getClickedFace();
        BlockPos origin = clickedPos.relative(face);
        int half = 3;
        if (mode == 0) {
            Block secondVariant;
            Block firstVariant = variants.get(rand.nextInt(variants.size()));
            while ((secondVariant = variants.get(rand.nextInt(variants.size()))) == firstVariant && variants.size() > 1) {
            }
            for (int dx = -half; dx <= half; ++dx) {
                for (int dz = -half; dz <= half; ++dz) {
                    BlockPos placePos = origin.offset(dx, 0, dz);
                    if (!level.isEmptyBlock(placePos)) continue;
                    boolean useFirst = Math.abs(dx + dz) % 2 == 0;
                    Block toPlace = useFirst ? firstVariant : secondVariant;
                    level.setBlock(placePos, toPlace.defaultBlockState(), 3);
                }
            }
        } else {
            HashSet<Block> usedInThisBuild = new HashSet<Block>();
            int variantCount = Math.min(variants.size(), 4);
            Collections.shuffle(variants);
            List<Block> chosen = variants.subList(0, variantCount);
            for (int dx = -half; dx <= half; ++dx) {
                for (int dz = -half; dz <= half; ++dz) {
                    Block toPlace;
                    BlockPos placePos = origin.offset(dx, 0, dz);
                    if (!level.isEmptyBlock(placePos)) continue;
                    Block lastX = dx > -half ? level.getBlockState(placePos.west()).getBlock() : null;
                    Block lastZ = dz > -half ? level.getBlockState(placePos.north()).getBlock() : null;
                    int tries = 0;
                    do {
                        toPlace = chosen.get(rand.nextInt(chosen.size()));
                    } while (++tries < 4 && (toPlace == lastX || toPlace == lastZ));
                    level.setBlock(placePos, toPlace.defaultBlockState(), 3);
                    usedInThisBuild.add(toPlace);
                }
            }
        }
        level.playSound(null, clickedPos, SoundEvents.STONE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private int getMode(ItemStack stack) {
        Integer mode = (Integer)stack.get(ModDataComponents.BUILDER_MODE);
        return mode != null ? mode : 0;
    }

    private List<Block> getVariantGroup(Block block) {
        for (Map.Entry<String, DeferredBlock<?>[]> entry : ModBlocks.VARIANTS.entrySet()) {
            for (DeferredBlock<?> variant : entry.getValue()) {
                if (variant.get() != block) continue;
                ArrayList<Block> blocks = new ArrayList<Block>();
                for (DeferredBlock<?> v : entry.getValue()) {
                    blocks.add((Block)v.get());
                }
                return blocks;
            }
        }
        return Collections.singletonList(block);
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

