/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

public class ShowcaseWandItem
extends Item {
    private static final int MODE_3x3 = 0;
    private static final int MODE_5x5 = 1;

    public ShowcaseWandItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player.isShiftKeyDown()) {
            Integer mode = (Integer)stack.get(ModDataComponents.BUILDER_MODE);
            int next = mode == null || mode == 0 ? 1 : 0;
            stack.set(ModDataComponents.BUILDER_MODE, (Object)next);
            String modeName = next == 0 ? "3x3 Platform" : "5x5 Platform";
            player.displayClientMessage((Component)Component.literal((String)("Mode set to: " + modeName)), true);
            level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.PLAYERS, 1.0f, 1.2f);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos clickedPos = context.getClickedPos();
        if (player == null || level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            Block clickedBlock = level.getBlockState(clickedPos).getBlock();
            stack.set(ModDataComponents.STORED_BLOCK, (Object)BuiltInRegistries.BLOCK.getKey((Object)clickedBlock));
            player.displayClientMessage((Component)Component.literal((String)("Saved block: " + clickedBlock.getName().getString())), true);
            level.playSound(null, clickedPos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        ResourceLocation savedId = (ResourceLocation)stack.get(ModDataComponents.STORED_BLOCK);
        if (savedId == null) {
            player.displayClientMessage((Component)Component.literal((String)"Sneak + Right-Click a block first to save it!"), true);
            return InteractionResult.FAIL;
        }
        Block baseBlock = (Block)BuiltInRegistries.BLOCK.get(savedId);
        if (baseBlock == null) {
            return InteractionResult.FAIL;
        }
        List<Block> variants = this.getVariantGroup(baseBlock);
        if (variants.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"No variants found for this block."), true);
            return InteractionResult.FAIL;
        }
        int mode = this.getMode(stack);
        int radius = mode == 0 ? 1 : 2;
        Direction face = context.getClickedFace();
        BlockPos origin = clickedPos.relative(face);
        int platformSize = radius * 2 + 1;
        int maxPerRow = 4;
        Direction right = player.getDirection().getClockWise();
        Direction forward = player.getDirection().getOpposite();
        for (int i = 0; i < variants.size(); ++i) {
            Block variant = variants.get(i);
            int row = i / maxPerRow;
            int col = i % maxPerRow;
            int xOffset = col * (platformSize + 1);
            int zOffset = row * (platformSize + 1);
            BlockPos start = origin.relative(right, xOffset).relative(forward, zOffset);
            this.buildPlatform(level, start, variant, radius);
        }
        level.playSound(null, clickedPos, SoundEvents.STONE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private void buildPlatform(Level level, BlockPos origin, Block block, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos placePos = origin.offset(dx, 0, dz);
                if (!level.isEmptyBlock(placePos)) continue;
                level.setBlock(placePos, block.defaultBlockState(), 3);
            }
        }
    }

    private int getMode(ItemStack stack) {
        Integer mode = (Integer)stack.get(ModDataComponents.BUILDER_MODE);
        return mode != null ? mode : 0;
    }

    private List<Block> getVariantGroup(Block block) {
        for (Map.Entry<String, DeferredBlock<?>[]> entry : ModBlocks.VARIANTS.entrySet()) {
            for (DeferredBlock<?> variant : entry.getValue()) {
                if (variant.get() != block) continue;
                ArrayList<Block> group = new ArrayList<Block>();
                for (DeferredBlock<?> v : entry.getValue()) {
                    group.add((Block)v.get());
                }
                return group;
            }
        }
        return Collections.singletonList(block);
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        int mode = this.getMode(stack);
        String modeName = mode == 0 ? "3x3 Platform" : "5x5 Platform";
        ResourceLocation saved = (ResourceLocation)stack.get(ModDataComponents.STORED_BLOCK);
        tooltip.add((Component)Component.literal((String)("Mode: " + modeName)));
        if (saved != null) {
            tooltip.add((Component)Component.literal((String)("Saved Block: " + saved.toString())));
        }
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.literal((String)"    Sneak + Right-Click a block to save.\n    Right-Click builds every variant platform.\n    Arranged 4 per row automatically.\n"));
        } else {
            tooltip.add((Component)Component.literal((String)"Hold SHIFT for more info."));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

