/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc.mixin;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.wuffs.bcc.data.BetterStatus;
import dev.wuffs.bcc.data.ExtendedServerStatus;
import java.util.Optional;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.status.ServerStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerStatus.class})
public class ServerStatusMixin
implements ExtendedServerStatus {
    @Shadow
    @Final
    @Mutable
    public static Codec<ServerStatus> CODEC;
    @Shadow
    @Final
    private Component description;
    @Unique
    private Optional<BetterStatus> bcc$betterStatus = Optional.empty();

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void bcc$onClassInit(CallbackInfo ci) {
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.lenientOptionalFieldOf("description", (Object)CommonComponents.EMPTY).forGetter(ServerStatus::description), (App)ServerStatus.Players.CODEC.lenientOptionalFieldOf("players").forGetter(ServerStatus::players), (App)ServerStatus.Version.CODEC.lenientOptionalFieldOf("version").forGetter(ServerStatus::version), (App)ServerStatus.Favicon.CODEC.lenientOptionalFieldOf("favicon").forGetter(ServerStatus::favicon), (App)Codec.BOOL.optionalFieldOf("enforcesSecureChat", (Object)false).forGetter(ServerStatus::enforcesSecureChat), (App)Codec.BOOL.optionalFieldOf("isModded", (Object)Boolean.FALSE).forGetter(ServerStatus::isModded), (App)BetterStatus.CODEC.lenientOptionalFieldOf("betterStatus").forGetter(status -> ((ExtendedServerStatus)status).getBetterData())).apply((Applicative)instance, (description, players, version, favicon, enforcesSecureChat, isModded, betterStatus) -> {
            ServerStatus status = new ServerStatus(description, players, version, favicon, enforcesSecureChat.booleanValue(), isModded.booleanValue());
            ((ExtendedServerStatus)status).setBetterData(betterStatus.orElse(null));
            return status;
        }));
    }

    @Override
    public Optional<BetterStatus> getBetterData() {
        return this.bcc$betterStatus;
    }

    @Override
    public void setBetterData(BetterStatus status) {
        this.bcc$betterStatus = Optional.ofNullable(status);
    }
}

