/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.jetbrains.annotations.Nullable;

public class SFMConfigTracker {
    private static final HashMap<IConfigSpec, Path> configPaths = new HashMap();

    @Nullable
    public static Path getPathForConfig(IConfigSpec spec) {
        return configPaths.get(spec);
    }

    @MCVersionDependentBehaviour
    private static Set<ModConfig> getModConfigs(ModConfig.Type modConfigType) {
        ConfigTracker configTracker = ConfigTracker.INSTANCE;
        try {
            Field configSetsField = configTracker.getClass().getDeclaredField("configSets");
            configSetsField.setAccessible(true);
            Map configSets = (Map)configSetsField.get(configTracker);
            return (Set)configSets.get(modConfigType);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    static ModConfig getServerModConfig() {
        Set<ModConfig> modConfigs = SFMConfigTracker.getModConfigs(ModConfig.Type.SERVER);
        for (ModConfig modConfig : modConfigs) {
            if (modConfig.getSpec() != SFMConfig.SERVER_CONFIG_SPEC) continue;
            return modConfig;
        }
        return null;
    }

    @Nullable
    static ModConfig getClientModConfig() {
        Set<ModConfig> modConfigs = SFMConfigTracker.getModConfigs(ModConfig.Type.CLIENT);
        for (ModConfig modConfig : modConfigs) {
            if (modConfig.getSpec() != SFMConfig.CLIENT_CONFIG_SPEC) continue;
            return modConfig;
        }
        return null;
    }

    @EventBusSubscriber(modid="sfm")
    public static class GameConfigEventListeners {
        @SubscribeEvent
        public static void onServerStopped(ServerStoppedEvent event) {
            configPaths.entrySet().removeIf(entry -> entry.getKey() == SFMConfig.SERVER_CONFIG_SPEC);
        }
    }

    @EventBusSubscriber(modid="sfm")
    public static class ModConfigEventListeners {
        @SubscribeEvent
        public static void onConfigLoaded(ModConfigEvent.Loading event) {
            ModConfigEventListeners.handleConfigEvent((ModConfigEvent)event);
        }

        @SubscribeEvent
        public static void onConfigReloaded(ModConfigEvent.Reloading event) {
            ModConfigEventListeners.handleConfigEvent((ModConfigEvent)event);
        }

        private static void handleConfigEvent(ModConfigEvent event) {
            IConfigSpec spec;
            Path path;
            ModConfig modConfig = event.getConfig();
            if (modConfig.getModId().equals("sfm") && (path = ModConfigEventListeners.getConfigPath(spec = modConfig.getSpec())) != null) {
                configPaths.put(spec, path);
            }
        }

        @MCVersionDependentBehaviour
        @Nullable
        private static Path getConfigPath(IConfigSpec configSpec) {
            IConfigSpec.ILoadedConfig loadedConfig;
            try {
                Field loadedConfigField = configSpec.getClass().getDeclaredField("loadedConfig");
                loadedConfigField.setAccessible(true);
                loadedConfig = (IConfigSpec.ILoadedConfig)loadedConfigField.get(configSpec);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                SFM.LOGGER.error("Failed to extract loadedConfig field", (Throwable)e);
                return null;
            }
            try {
                Class loadedConfigClass = loadedConfig.getClass();
                Field pathField = loadedConfigClass.getDeclaredField("path");
                pathField.setAccessible(true);
                return (Path)pathField.get(loadedConfig);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                SFM.LOGGER.error("Failed to extract path field", (Throwable)e);
                return null;
            }
        }
    }
}

