/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.IOutputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceLimit;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.resources.ResourceLocation;

public class SharedQuantityExpandedRetentionOutputResourceTracker
implements IOutputResourceTracker {
    private final ResourceLimit resource_limit;
    private final ResourceIdSet exclusions;
    private final Object2ObjectOpenHashMap<ResourceType<?, ?, ?>, Object2LongOpenHashMap<ResourceLocation>> retention_obligations_by_item = new Object2ObjectOpenHashMap();
    private long transferred = 0L;

    public SharedQuantityExpandedRetentionOutputResourceTracker(ResourceLimit resourceLimit, ResourceIdSet exclusions) {
        this.resource_limit = resourceLimit;
        this.exclusions = exclusions;
    }

    @Override
    public ResourceLimit getResourceLimit() {
        return this.resource_limit;
    }

    @Override
    public ResourceIdSet getExclusions() {
        return this.exclusions;
    }

    @Override
    public <STACK, CAP, ITEM> boolean isDone(ResourceType<STACK, ITEM, CAP> type, STACK stack) {
        long max_transfer = this.resource_limit.limit().quantity().number().value();
        if (this.transferred >= max_transfer) {
            return true;
        }
        long max_put = this.resource_limit.limit().retention().number().value();
        long retained_for_item = 0L;
        Object2LongOpenHashMap retained_for_resource_type = (Object2LongOpenHashMap)this.retention_obligations_by_item.get(type);
        if (retained_for_resource_type != null) {
            ResourceLocation item_id = type.getRegistryKeyForStack(stack);
            retained_for_item = retained_for_resource_type.getLong((Object)item_id);
        }
        return retained_for_item >= max_put;
    }

    @Override
    public <STACK, ITEM, CAP> void updateRetentionObservation(ResourceType<STACK, ITEM, CAP> type, STACK observed) {
        if (this.matchesStack(observed)) {
            ResourceLocation item_id = type.getRegistryKeyForStack(observed);
            ((Object2LongOpenHashMap)this.retention_obligations_by_item.computeIfAbsent(type, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, type.getAmount(observed));
        }
    }

    @Override
    public <STACK, ITEM, CAP> long getMaxTransferable(ResourceType<STACK, ITEM, CAP> resourceType, STACK key) {
        long max_transfer = this.resource_limit.limit().quantity().number().value();
        long unusedQuantity = max_transfer - this.transferred;
        long max_retain = this.resource_limit.limit().retention().number().value();
        long retained_for_item = 0L;
        Object2LongOpenHashMap retained_for_resource_type = (Object2LongOpenHashMap)this.retention_obligations_by_item.get(resourceType);
        if (retained_for_resource_type != null) {
            ResourceLocation item_id = resourceType.getRegistryKeyForStack(key);
            retained_for_item = retained_for_resource_type.getLong((Object)item_id);
        }
        long remainingRetentionRoom = max_retain - retained_for_item;
        return Math.min(unusedQuantity, remainingRetentionRoom);
    }

    @Override
    public <STACK, ITEM, CAP> void trackTransfer(ResourceType<STACK, ITEM, CAP> resourceType, STACK key, long amount) {
        ResourceLocation item_id = resourceType.getRegistryKeyForStack(key);
        this.transferred += amount;
        ((Object2LongOpenHashMap)this.retention_obligations_by_item.computeIfAbsent(resourceType, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, amount);
    }

    public String toString() {
        return "SharedQuantityExpandedRetentionOutputResourceTracker{resource_limit=" + String.valueOf(this.resource_limit) + ", exclusions=" + String.valueOf(this.exclusions) + ", transferred=" + this.transferred + ", retention_obligations_by_item=" + String.valueOf(this.retention_obligations_by_item) + "}";
    }
}

