/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity.bolt;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public abstract class AbstractBoltEntityRenderer<T extends AbstractBoltProjectileEntity>
extends EntityRenderer<T> {
    public final Color primaryColor;
    public final Color secondaryColor;

    public AbstractBoltEntityRenderer(EntityRendererProvider.Context context, Color primaryColor, Color secondaryColor) {
        super(context);
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.shadowRadius = 0.0f;
        this.shadowStrength = 0.0f;
    }

    public LodestoneRenderTypeBuilder getTrailRenderType(boolean isTransparent) {
        return isTransparent ? LodestoneRenderTypes.TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL).withUniformHandler(ShaderUniformHandler.LUMITRANSPARENT) : LodestoneRenderTypes.ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
    }

    public Color getPrimaryColor(int trailIndex) {
        if (trailIndex < 2) {
            return ColorHelper.darker((Color)this.primaryColor, (int)3);
        }
        return this.primaryColor;
    }

    public Color getSecondaryColor(int trailIndex) {
        if (trailIndex < 2) {
            return ColorHelper.darker((Color)this.secondaryColor, (int)3);
        }
        return this.secondaryColor;
    }

    public float getAlphaMultiplier() {
        return 1.0f;
    }

    public float getScaleMultiplier() {
        return 1.4f;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        if (((AbstractBoltProjectileEntity)((Object)entity)).spawnDelay > 0) {
            return;
        }
        float delta = ((AbstractBoltProjectileEntity)((Object)entity)).getVisualEffectScalar();
        float scale = delta * this.getScaleMultiplier();
        float alpha = Mth.clamp((float)(delta * this.getAlphaMultiplier()), (float)0.0f, (float)1.0f);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType(this.getTrailRenderType(true));
        RenderUtils.renderEntityTrail(poseStack, builder, ((AbstractBoltProjectileEntity)((Object)entity)).trailPointBuilder, entity, this.getPrimaryColor(0), this.getSecondaryColor(0), scale * 2.0f, alpha, partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder, ((AbstractBoltProjectileEntity)((Object)entity)).spinningTrailPointBuilder, entity, this.getPrimaryColor(1), this.getSecondaryColor(1), scale * 2.0f, alpha, partialTicks);
        builder.setRenderType(this.getTrailRenderType(false));
        RenderUtils.renderEntityTrail(poseStack, builder, ((AbstractBoltProjectileEntity)((Object)entity)).trailPointBuilder, entity, this.getPrimaryColor(2), this.getSecondaryColor(2), scale, alpha, partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder, ((AbstractBoltProjectileEntity)((Object)entity)).spinningTrailPointBuilder, entity, this.getPrimaryColor(3), this.getSecondaryColor(3), scale, alpha, partialTicks);
        super.render(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

