/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.renderpass;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.sammy.malum.common.data.attachment.WeepingWellData;
import com.sammy.malum.config.ClientConfig;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.client.MalumRenderTypes;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import team.lodestar.lodestone.helpers.StateShardHelper;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.cube.CubeVertexData;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.renderpass.BeforeLevelRenderPass;

public class ParallelWorldRenderer
extends BeforeLevelRenderPass {
    public static ParallelWorldRenderer INSTANCE;
    private final RenderTarget target = new TextureTarget(Minecraft.getInstance().getWindow().getWidth() / 2, Minecraft.getInstance().getWindow().getHeight() / 2, true, Minecraft.ON_OSX);
    private static final RenderStateShard.OutputStateShard outputState;

    public ParallelWorldRenderer() {
        INSTANCE = this;
    }

    public void render(DeltaTracker deltaTracker, Camera camera, GameRenderer gameRenderer, Matrix4f viewMat, Matrix4f projMat) {
        Minecraft mc = Minecraft.getInstance();
        long gameTime = mc.level.getGameTime();
        float partialTicks = deltaTracker.getGameTimeDeltaTicks();
        float uOffset = ((float)gameTime + partialTicks) % 4000.0f / 2000.0f;
        float vOffset = ((float)gameTime + 500.0f + partialTicks) % 8000.0f / 8000.0f;
        this.target.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.target.clear(Minecraft.ON_OSX);
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        matrix4fstack.mul((Matrix4fc)viewMat);
        RenderSystem.applyModelViewMatrix();
        PoseStack poseStack = new PoseStack();
        poseStack.pushPose();
        int cubeScale = 100;
        poseStack.scale((float)cubeScale, (float)cubeScale, (float)cubeScale);
        poseStack.mulPose(Axis.XP.rotationDegrees(((float)gameTime + partialTicks) * 0.4f % 360.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(((float)gameTime + partialTicks) * 0.2f % 360.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(((float)gameTime + partialTicks) * 0.1f % 360.0f));
        for (int i = 0; i < 4; ++i) {
            float speed = 1000.0f + 750.0f * (float)i;
            float distortion = 4.0f + (float)(2 * i);
            float scale = 2.0f - 0.05f * (float)i;
            float red = 0.8f;
            float green = 0.6f;
            float blue = 0.7f;
            float alpha = 0.8f - (float)i * 0.05f;
            Color color = new Color(red, green, blue);
            ShaderUniformHandler uniforms = new ShaderUniformHandler().modifyUniform("Speed", new float[]{speed}).modifyUniform("Distortion", new float[]{distortion}).modifyUniform("Width", new float[]{512.0f}).modifyUniform("Height", new float[]{512.0f}).modifyUniform("UVCoordinates", new float[]{-20.0f, 40.0f, -20.0f, 40.0f});
            LodestoneRenderTypeBuilder builder = MalumRenderTypes.WEEPING_SKYBOX.apply(MalumRenderTypeTokens.VOID_NOISE).withUniformHandler(uniforms);
            LodestoneRenderType renderType = builder.getRenderType();
            VertexConsumer consumer = bufferSource.getBuffer((RenderType)renderType);
            VFXBuilders.WorldVFXBuilder vfxBuilder = VFXBuilders.createWorld().setVertexConsumer(consumer).setRenderType((RenderType)renderType).setColor(color).setAlpha(alpha);
            CubeVertexData cubeData = CubeVertexData.makeCubePositions((float)(-scale)).applyWobble(0.0f, 0.5f, 0.015f);
            vfxBuilder.setUV(-uOffset, vOffset, 1.0f - uOffset, 1.0f + vOffset).renderCube(poseStack, cubeData);
            vfxBuilder.setUV(uOffset * 2.0f, -vOffset * 2.0f, (1.0f + uOffset) * 2.0f, (1.0f - vOffset) * 2.0f).renderCube(poseStack, cubeData);
            uOffset = -uOffset * 1.25f - 0.2f;
            vOffset = -vOffset * 1.25f + 0.4f;
            bufferSource.endBatch((RenderType)renderType);
        }
        poseStack.popPose();
        matrix4fstack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
    }

    public boolean shouldRender(DeltaTracker deltaTracker, Camera camera, GameRenderer gameRenderer, Matrix4f matrix4f, Matrix4f matrix4f1) {
        if (!((Boolean)ClientConfig.PARALLEL_WORLD.getConfigValue()).booleanValue()) {
            return false;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        if (player.hasData(MalumAttachmentTypes.WEEPING_WELL_INFO)) {
            return ((WeepingWellData)player.getData(MalumAttachmentTypes.WEEPING_WELL_INFO)).isNearWeepingWell;
        }
        return false;
    }

    public void resize(int width, int height) {
        this.target.resize(width, height, Minecraft.ON_OSX);
    }

    public RenderTarget getTarget() {
        return this.target;
    }

    public static RenderStateShard.OutputStateShard getOutputState() {
        return outputState;
    }

    static {
        outputState = StateShardHelper.createOutputState((String)"parallelWorld", () -> ParallelWorldRenderer.INSTANCE.target.bindWrite(false));
    }
}

