/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.handlers;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;

public class BookObjectHandler<T extends AbstractMalumCodexScreen> {
    protected final ArrayList<BookObject<T>> objects = new ArrayList();

    public void add(BookObject<T> object) {
        this.objects.add(object);
    }

    public void addAll(Collection<? extends BookObject<T>> objects) {
        this.objects.addAll(objects);
    }

    public ArrayList<BookObject<T>> getObjects() {
        return this.objects;
    }

    public BookObject<T> get(int index) {
        return this.objects.get(index);
    }

    public BookObject<T> getFirst() {
        return this.objects.getFirst();
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public void remove(BookObject<T> object) {
        this.objects.remove(object);
    }

    public void tick(T screen) {
        Minecraft minecraft = Minecraft.getInstance();
        MouseHandler mouseHandler = minecraft.mouseHandler;
        Window window = minecraft.getWindow();
        double x = mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        double y = mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        this.tick(screen, x, y);
    }

    public void tick(T screen, double mouseX, double mouseY) {
        for (BookObject<T> object : this.objects) {
            if (!object.isValid(screen)) continue;
            object.tick(screen, mouseX, mouseY);
        }
    }

    public boolean click(T screen, double mouseX, double mouseY) {
        ArrayList<BookObject<T>> sorted = new ArrayList<BookObject<T>>();
        for (BookObject<T> bookObject : this.objects) {
            if (!bookObject.isValid(screen)) continue;
            if (bookObject.hasPriority(screen)) {
                sorted.addFirst(bookObject);
                continue;
            }
            sorted.add(bookObject);
        }
        for (BookObject<Object> bookObject : sorted) {
            if (!bookObject.isValid(screen) || !bookObject.tryClick(screen, mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVisibleObject(T screen) {
        for (BookObject<T> object : this.objects) {
            if (!object.isInView(screen)) continue;
            return true;
        }
        return false;
    }

    public void renderObjects(T screen, GuiGraphics guiGraphics, float left, float top, int mouseX, int mouseY, float partialTicks) {
        for (int i = this.objects.size() - 1; i >= 0; --i) {
            BookObject<T> object = this.objects.get(i);
            if (!object.isValid(screen)) continue;
            object.xOffset = left;
            object.yOffset = top;
            if (!object.isSubspace && !object.isInView(screen)) {
                object.isHoveredOver = false;
                continue;
            }
            object.isHoveredOver = object.isHovering(screen, mouseX, mouseY);
            this.renderObject(screen, guiGraphics, object, mouseX, mouseY, partialTicks);
        }
    }

    public void renderObject(T screen, GuiGraphics guiGraphics, BookObject<T> object, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        object.applyTransforms(screen, poseStack, mouseX, mouseY, partialTicks);
        object.render(screen, guiGraphics, mouseX, mouseY, partialTicks);
        poseStack.popPose();
    }

    public void renderObjectsLate(T screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        boolean priorityOnly = false;
        for (BookObject<T> object : this.objects) {
            if (!object.isValid(screen) || !object.hasPriority(screen)) continue;
            priorityOnly = true;
            break;
        }
        for (int i = this.objects.size() - 1; i >= 0; --i) {
            BookObject<T> object;
            object = this.objects.get(i);
            if (priorityOnly && !object.hasPriority(screen) || !object.isValid(screen)) continue;
            object.renderLate(screen, guiGraphics, mouseX, mouseY, partialTicks);
        }
    }
}

