/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.screen.codex.screens.progression.AbstractProgressionCodexScreen;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.rite.SpiritRiteType;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.client.MalumShaders;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector4f;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class CodexRenderHelper {
    protected static final VFXBuilders.ScreenVFXBuilder VFX_BUILDER = VFXBuilders.createScreen();

    public static <T extends AbstractProgressionCodexScreen> void renderTransitionFade(T screen, PoseStack stack) {
        float pct = screen.getVoidFadeoutDelta();
        float overlayAlpha = Easing.SINE_IN_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
        float effectStrength = Easing.QUAD_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
        float effectAlpha = Math.min(1.0f, effectStrength * 1.0f);
        float zoom = 0.5f + Math.min(0.35f, effectStrength);
        float intensity = 1.0f + (effectStrength > 0.5f ? (effectStrength - 0.5f) * 2.5f : 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        int left = screen.getInsideLeft();
        int top = screen.getInsideTop();
        int width = 344;
        int height = 218;
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPositionWithWidth((float)left, (float)top, (float)width, (float)height).setColor(0, 0, 0).setAlpha(overlayAlpha).setZLevel(200).setShader(GameRenderer::getPositionColorShader).blit(stack);
        ExtendedShaderInstance shaderInstance = MalumShaders.TOUCH_OF_DARKNESS.getShaderInstance();
        shaderInstance.safeGetUniform("Speed").set(1000.0f);
        Consumer<Float> setZoom = f -> shaderInstance.safeGetUniform("Zoom").set(f.floatValue());
        Consumer<Float> setIntensity = f -> shaderInstance.safeGetUniform("Intensity").set(f.floatValue());
        builder.setAlpha(effectAlpha).setShader((ShaderInstance)shaderInstance);
        setZoom.accept(Float.valueOf(zoom));
        setIntensity.accept(Float.valueOf(intensity));
        builder.blit(stack);
        setZoom.accept(Float.valueOf(zoom * 1.25f + 0.15f));
        setIntensity.accept(Float.valueOf(intensity * 0.8f + 0.5f));
        builder.blit(stack);
        shaderInstance.setUniformDefaults();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderGeasIcon(ResourceLocation location, PoseStack stack, GeasEffectType type, float x, float y) {
        CodexRenderHelper.renderGeasIcon(location, stack, type, x, y, 0);
    }

    public static void renderGeasIcon(ResourceLocation texture, PoseStack stack, GeasEffectType type, float x, float y, int z) {
        ExtendedShaderInstance shaderInstance = LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getShaderInstance();
        shaderInstance.safeGetUniform("YFrequency").set(10.0f);
        shaderInstance.safeGetUniform("XFrequency").set(12.0f);
        shaderInstance.safeGetUniform("Speed").set(2000.0f);
        shaderInstance.safeGetUniform("Intensity").set(50.0f);
        shaderInstance.safeGetUniform("UVCoordinates").set(new Vector4f(0.0f, 1.0f, 0.0f, 1.0f));
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader((ShaderInstance)shaderInstance).setZLevel(z);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        AtomicInteger cycle = new AtomicInteger();
        List<SpiritHolder<SpiritArcanaType>> spirits = type.spiritTypes;
        Function<Function, Color> colorSupplier = b -> (Color)b.apply((SpiritLike)spirits.get(cycle.getAndIncrement() % spirits.size()));
        Color mainColor = colorSupplier.apply(SpiritLike::getPrimaryColor);
        if (spirits.getFirst().equals(MalumSpiritTypes.AQUEOUS_SPIRIT)) {
            mainColor = ColorHelper.brighter((Color)mainColor, (int)2);
        }
        if (spirits.getFirst().equals(MalumSpiritTypes.SACRED_SPIRIT) || spirits.getFirst().equals(MalumSpiritTypes.WICKED_SPIRIT)) {
            mainColor = ColorHelper.brighter((Color)mainColor, (int)1);
        }
        builder.setColor(colorSupplier.apply(SpiritLike::getPrimaryColor)).multiplyColor(0.24f).setAlpha(0.6f);
        CodexRenderHelper.renderTexture(texture, stack, builder, x - 1.0f, y, 0, 0.0f, 0.0f, 16, 16);
        CodexRenderHelper.renderTexture(texture, stack, builder, x + 1.0f, y, 1, 0.0f, 0.0f, 16, 16);
        builder.setColor(colorSupplier.apply(SpiritLike::getPrimaryColor)).multiplyColor(0.24f);
        CodexRenderHelper.renderTexture(texture, stack, builder, x, y - 1.0f, 2, 0.0f, 0.0f, 16, 16);
        CodexRenderHelper.renderTexture(texture, stack, builder, x, y + 0.8f, 3, 0.0f, 0.0f, 16, 16);
        RenderSystem.blendFunc((int)770, (int)1);
        builder.setColor(mainColor).setAlpha(0.7f);
        shaderInstance.safeGetUniform("Speed").set(1000.0f);
        CodexRenderHelper.renderTexture(texture, stack, builder, x, y, 4, 0.0f, 0.0f, 16, 16);
        builder.setColor(ColorHelper.brighter((Color)mainColor, (int)4)).setAlpha(0.2f);
        shaderInstance.safeGetUniform("Speed").set(400.0f);
        CodexRenderHelper.renderTexture(texture, stack, builder, x + 2.0f, y + 2.0f, 5, 2.0f, 2.0f, 12, 12, 16, 16);
        builder.setColor(colorSupplier.apply(SpiritLike::getSecondaryColor));
        shaderInstance.safeGetUniform("Speed").set(2000.0f);
        CodexRenderHelper.renderTexture(texture, stack, builder, x + 1.0f, y, 6, 0.0f, 0.0f, 16, 16);
        CodexRenderHelper.renderTexture(texture, stack, builder, x - 1.0f, y, 7, 0.0f, 0.0f, 16, 16);
        builder.setColor(colorSupplier.apply(SpiritLike::getSecondaryColor));
        CodexRenderHelper.renderTexture(texture, stack, builder, x, y + 1.0f, 8, 0.0f, 0.0f, 16, 16);
        CodexRenderHelper.renderTexture(texture, stack, builder, x, y - 1.0f, 9, 0.0f, 0.0f, 16, 16);
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        shaderInstance.setUniformDefaults();
    }

    public static void renderWavyIcon(ResourceLocation location, PoseStack stack, float x, float y, int textureWidth, int textureHeight) {
        CodexRenderHelper.renderWavyIcon(location, stack, x, y, 0, textureWidth, textureHeight);
    }

    public static void renderWavyIcon(ResourceLocation location, PoseStack stack, float x, float y, int z, int textureWidth, int textureHeight) {
        ExtendedShaderInstance shaderInstance = LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getShaderInstance();
        shaderInstance.safeGetUniform("YFrequency").set(10.0f);
        shaderInstance.safeGetUniform("XFrequency").set(12.0f);
        shaderInstance.safeGetUniform("Speed").set(1000.0f);
        shaderInstance.safeGetUniform("Intensity").set(50.0f);
        shaderInstance.safeGetUniform("UVCoordinates").set(new Vector4f(0.0f, 1.0f, 0.0f, 1.0f));
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader((ShaderInstance)shaderInstance).setAlpha(0.7f).setZLevel(z);
        RenderSystem.blendFunc((int)770, (int)1);
        CodexRenderHelper.renderTexture(location, stack, builder, x, y, 0, 0.0f, 0.0f, textureWidth, textureHeight);
        builder.setAlpha(0.1f);
        shaderInstance.safeGetUniform("Speed").set(2000.0f);
        CodexRenderHelper.renderTexture(location, stack, builder, x - 1.0f, y, 1, 0.0f, 0.0f, textureWidth, textureHeight);
        CodexRenderHelper.renderTexture(location, stack, builder, x + 1.0f, y, 2, 0.0f, 0.0f, textureWidth, textureHeight);
        CodexRenderHelper.renderTexture(location, stack, builder, x, y - 1.0f, 3, 0.0f, 0.0f, textureWidth, textureHeight);
        CodexRenderHelper.renderTexture(location, stack, builder, x, y + 1.0f, 4, 0.0f, 0.0f, textureWidth, textureHeight);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
    }

    public static void renderRiteIcon(SpiritRiteType rite, PoseStack stack, float x, float y) {
        CodexRenderHelper.renderSpiritIcon(rite.getIcon(), stack, rite.getIdentifyingSpirit(), rite.isCorrupted(), x, y, 0);
    }

    public static void renderSpiritIcon(ResourceLocation texture, PoseStack stack, SpiritLike spiritType, boolean corrupted, float x, float y) {
        CodexRenderHelper.renderSpiritIcon(texture, stack, spiritType, corrupted, x, y, 0);
    }

    public static void renderSpiritIcon(ResourceLocation texture, PoseStack stack, SpiritLike spiritType, boolean corrupted, float x, float y, int z) {
        CodexRenderHelper.renderSpiritIcon(texture, stack, spiritType, corrupted, x, y, z, 16, 16);
    }

    public static void renderSpiritIcon(ResourceLocation texture, PoseStack stack, SpiritLike spiritType, boolean corrupted, float x, float y, int textureWidth, int textureHeight) {
        CodexRenderHelper.renderSpiritIcon(texture, stack, spiritType, corrupted, x, y, 0, textureWidth, textureHeight);
    }

    public static void renderSpiritIcon(ResourceLocation texture, PoseStack stack, SpiritLike spiritType, boolean corrupted, float x, float y, int z, int textureWidth, int textureHeight) {
        ExtendedShaderInstance shaderInstance = LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getShaderInstance();
        float intensity = corrupted ? 30.0f : 50.0f;
        shaderInstance.safeGetUniform("YFrequency").set(corrupted ? 5.0f : 10.0f);
        shaderInstance.safeGetUniform("XFrequency").set(corrupted ? 9.0f : 18.0f);
        shaderInstance.safeGetUniform("Speed").set(corrupted ? -1000.0f : 1500.0f);
        shaderInstance.safeGetUniform("Intensity").set(intensity);
        shaderInstance.safeGetUniform("UVCoordinates").set(new Vector4f(0.0f, 1.0f, 0.0f, 1.0f));
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader((ShaderInstance)shaderInstance).setZLevel(z);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((int)770, (int)1);
        Color color = spiritType.getPrimaryColor();
        Color secondaryColor = spiritType.getPrimaryColor();
        builder.setColor(color).setAlpha(0.95f);
        CodexRenderHelper.renderTexture(texture, stack, builder, x, y, 0, 0.0f, 0.0f, textureWidth, textureHeight);
        builder.setAlpha(0.3f);
        CodexRenderHelper.renderTexture(texture, stack, builder, x + 1.0f, y, 2, 0.0f, 0.0f, textureWidth, textureHeight);
        CodexRenderHelper.renderTexture(texture, stack, builder, x - 1.0f, y, 3, 0.0f, 0.0f, textureWidth, textureHeight);
        builder.setColor(secondaryColor).setAlpha(0.3f);
        shaderInstance.safeGetUniform("Intensity").set(-intensity);
        CodexRenderHelper.renderTexture(texture, stack, builder, x, y + 1.0f, 4, 0.0f, 0.0f, textureWidth, textureHeight);
        CodexRenderHelper.renderTexture(texture, stack, builder, x, y - 1.0f, 5, 0.0f, 0.0f, textureWidth, textureHeight);
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        shaderInstance.setUniformDefaults();
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, float x, float y, float u, float v, int width, int height) {
        CodexRenderHelper.renderTexture(texture, poseStack, x, y, u, v, width, height, width, height);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, float x, float y, int z, float u, float v, int width, int height) {
        CodexRenderHelper.renderTexture(texture, poseStack, x, y, z, u, v, width, height, width, height);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, float x, float y, float u, float v, int width, int height, int canvasWidth, int canvasHeight) {
        CodexRenderHelper.renderTexture(texture, poseStack, VFX_BUILDER, x, y, 0, u, v, width, height, canvasWidth, canvasHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, float x, float y, int z, float u, float v, int width, int height, int canvasWidth, int canvasHeight) {
        CodexRenderHelper.renderTexture(texture, poseStack, VFX_BUILDER, x, y, z, u, v, width, height, canvasWidth, canvasHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, float x, float y, int z, float u, float v, int width, int height) {
        CodexRenderHelper.renderTexture(texture, poseStack, builder, x, y, z, u, v, width, height, width, height);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, float x, float y, float u, float v, int width, int height, int canvasWidth, int canvasHeight) {
        CodexRenderHelper.renderTexture(texture, poseStack, builder, x, y, 0, u, v, width, height, canvasWidth, canvasHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, float x, float y, int z, float u, float v, int width, int height, int canvasWidth, int canvasHeight) {
        CodexRenderHelper.renderTexture(poseStack, builder.setTexture(texture).setPositionWithWidth(x, y, (float)width, (float)height), z, u, v, width, height, canvasWidth, canvasHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, float x, float y, float u, float v, int width, int height, int textureWidth, int textureHeight, int canvasWidth, int canvasHeight) {
        CodexRenderHelper.renderTexture(texture, poseStack, builder, x, y, 0, u, v, width, height, textureWidth, textureHeight, canvasWidth, canvasHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, float x, float y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight, int canvasWidth, int canvasHeight) {
        CodexRenderHelper.renderTexture(poseStack, builder.setTexture(texture).setPositionWithWidth(x, y, (float)width, (float)height), z, u, v, textureWidth, textureHeight, canvasWidth, canvasHeight);
    }

    private static void renderTexture(PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, int z, float u, float v, int width, int height, int canvasWidth, int canvasHeight) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        builder.setZLevel(z).setUVWithWidth(u, v, (float)width, (float)height, (float)canvasWidth, (float)canvasHeight).blit(poseStack);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }
}

