/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.screens;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.handlers.BookObjectHandler;
import com.sammy.malum.client.screen.codex.helper.CodexRenderHelper;
import com.sammy.malum.client.screen.codex.objects.ArrowObject;
import com.sammy.malum.client.screen.codex.objects.ReferencedEntryObject;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.client.screen.codex.screens.progression.ProgressionScreenHolder;
import com.sammy.malum.config.ClientConfig;
import com.sammy.malum.registry.common.MalumSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class CodexEntryScreen
extends AbstractMalumCodexScreen {
    public static final ResourceLocation BOOK_TEXTURE = MalumMod.malumPath("textures/gui/book/entry.png");
    public static final ResourceLocation ITEM_SOCKET = MalumMod.malumPath("textures/gui/book/entry_elements/item_sockets.png");
    protected static final int BOOK_WIDTH = 312;
    protected static final int BOOK_HEIGHT = 206;
    public static float textJump;
    @Nullable
    protected final AbstractMalumCodexScreen parentScreen;
    protected final BookEntry openEntry;
    protected int openPageIndex;
    protected final BookObjectHandler<CodexEntryScreen> entryObjects = new BookObjectHandler();
    protected final Minecraft minecraft = Minecraft.getInstance();

    public CodexEntryScreen(BookEntry openEntry) {
        this(null, openEntry);
    }

    public CodexEntryScreen(@Nullable AbstractMalumCodexScreen parentScreen, BookEntry openEntry) {
        super((Component)Component.empty(), (Holder<SoundEvent>)(openEntry.isVoid ? MalumSoundEvents.ARCANA_SWEETENER_EVIL : MalumSoundEvents.ARCANA_SWEETENER_NORMAL));
        this.parentScreen = parentScreen;
        this.openEntry = openEntry;
        int left = -21;
        int right = 297;
        this.entryObjects.add(new ArrowObject(left, 150, false));
        this.entryObjects.add(new ArrowObject(right, 150, true));
        ImmutableList<EntryReference> references = openEntry.references;
        if (references != null) {
            int counter = 0;
            for (EntryReference reference : references) {
                if (!reference.entry.shouldShow()) continue;
                this.entryObjects.add(new ReferencedEntryObject(right, 15 + counter * 30, true, reference));
                ++counter;
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        boolean isRightSide;
        BookPage page;
        int openPages;
        int i;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        PoseStack poseStack = guiGraphics.pose();
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        CodexRenderHelper.renderTexture(BOOK_TEXTURE, poseStack, guiLeft, guiTop, 0.0f, 0.0f, 312, 206);
        int pageTop = guiTop + 11;
        if (!this.openEntry.pages.isEmpty()) {
            for (i = openPages = this.openPageIndex * 2; i < openPages + 2; ++i) {
                if (i >= this.openEntry.pages.size()) continue;
                page = (BookPage)this.openEntry.pages.get(i);
                isRightSide = i % 2 == 1;
                int backgroundLeft = guiLeft + (isRightSide ? 165 : 13);
                ResourceLocation background = page.getBackground(isRightSide);
                if (background == null) continue;
                CodexRenderHelper.renderTexture(background, poseStack, backgroundLeft, pageTop, 0.0f, 0.0f, 134, 172);
            }
        }
        this.entryObjects.renderObjects(this, guiGraphics, guiLeft, guiTop, mouseX, mouseY, partialTicks);
        if (!this.openEntry.pages.isEmpty()) {
            for (i = openPages = this.openPageIndex * 2; i < openPages + 2; ++i) {
                if (i >= this.openEntry.pages.size()) continue;
                page = (BookPage)this.openEntry.pages.get(i);
                isRightSide = i % 2 == 1;
                int pageLeft = guiLeft + (isRightSide ? 161 : 9);
                boolean isRepeat = i % 2 != 0 && page.getClass().equals(((BookPage)this.openEntry.pages.get(i - 1)).getClass());
                page.render(this, guiGraphics, pageLeft, pageTop, mouseX, mouseY, partialTicks, isRepeat);
                this.lateRendering.add(() -> page.renderLate(this, guiGraphics, pageLeft, pageTop, mouseX, mouseY, partialTicks, isRepeat));
            }
        }
        this.entryObjects.renderObjectsLate(this, guiGraphics, mouseX, mouseY, partialTicks);
        this.doLateRendering();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.entryObjects.click(this, mouseX, mouseY);
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        if (!this.openEntry.pages.isEmpty()) {
            int openPages;
            for (int i = openPages = this.openPageIndex * 2; i < openPages + 2; ++i) {
                int pageTop;
                if (i >= this.openEntry.pages.size()) continue;
                BookPage page = (BookPage)this.openEntry.pages.get(i);
                boolean isRightSide = i % 2 == 1;
                int pageLeft = guiLeft + (isRightSide ? 161 : 9);
                if (!this.isHovering(mouseX, mouseY, pageLeft, pageTop = guiTop + 8, 142, 172)) continue;
                double relativeX = Mth.clamp((double)(mouseX - (double)guiLeft), (double)guiLeft, (double)(guiLeft + 142));
                double relativeY = Mth.clamp((double)(mouseY - (double)guiTop), (double)guiTop, (double)(guiTop + 172));
                page.click(this, pageLeft, pageTop, mouseX, mouseY, relativeX, relativeY);
            }
        }
        textJump += 1.0f;
        return false;
    }

    public void tick() {
        super.tick();
        this.entryObjects.tick(this);
        textJump = Math.max(textJump - 0.1f, 0.0f);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (((Boolean)ClientConfig.SCROLL_DIRECTION.getConfigValue()).booleanValue()) {
            scrollY = -scrollY;
        }
        if (scrollY > 0.0) {
            this.nextPage();
        } else {
            this.previousPage(false);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyRight.matches(keyCode, scanCode)) {
            this.nextPage();
            return true;
        }
        if (this.minecraft.options.keyLeft.matches(keyCode, scanCode)) {
            this.previousPage(true);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        this.close(false);
    }

    public boolean hasNextPage() {
        return (float)this.openPageIndex < (float)this.openEntry.pages.size() / 2.0f - 1.0f;
    }

    public void nextPage() {
        if (this.hasNextPage()) {
            ++this.openPageIndex;
            this.playPageFlipSound((Holder<SoundEvent>)MalumSoundEvents.ARCANA_PAGE_FLIP, this.getSweetenerPitch());
        }
    }

    public void previousPage(boolean ignore) {
        if (this.openPageIndex > 0) {
            --this.openPageIndex;
            this.playPageFlipSound((Holder<SoundEvent>)MalumSoundEvents.ARCANA_PAGE_FLIP, this.getSweetenerPitch());
        } else {
            this.close(ignore);
        }
    }

    public void close(boolean ignoreNextInput) {
        if (this.parentScreen == null) {
            ProgressionScreenHolder.getAppropriateCodexScreen().reopenCodexFromEntryScreen(this.isVoidTouched, ignoreNextInput);
        } else {
            ProgressionScreenHolder.openCodex(this.parentScreen, this.isVoidTouched, ignoreNextInput);
        }
        this.playSweetenedSound((Holder<SoundEvent>)MalumSoundEvents.ARCANA_ENTRY_CLOSE, 0.85f);
    }

    public static void openScreen(BookEntry bookEntry) {
        CodexEntryScreen screen;
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen2 = minecraft.screen;
        if (screen2 instanceof AbstractMalumCodexScreen) {
            AbstractMalumCodexScreen openScreen = (AbstractMalumCodexScreen)screen2;
            screen = new CodexEntryScreen(openScreen, bookEntry);
            screen.setVoidTouched(openScreen.isVoidTouched);
        } else {
            screen = new CodexEntryScreen(bookEntry);
        }
        screen.playSweetenedSound((Holder<SoundEvent>)MalumSoundEvents.ARCANA_ENTRY_OPEN, 1.15f);
        minecraft.setScreen((Screen)screen);
    }

    public float getSweetenerPitch() {
        return 1.0f + (float)this.openPageIndex / (float)this.openEntry.pages.size();
    }

    public int getGuiLeft() {
        return (this.width - 312) / 2;
    }

    public int getGuiTop() {
        return (this.height - 206) / 2;
    }
}

