/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.obelisk.rite_pylon;

import com.sammy.malum.common.block.MalumSpiritBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.obelisk.ObeliskCoreBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_altar.IAltarAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_altar.SpiritAltarBlockEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.registry.rite.RiteEffectHolder;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEmpowermentEffect;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.registry.common.magic.rite.MalumSpiritRiteEffectTypes;
import com.sammy.malum.visual_effects.SpiritAltarParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.arcana_pylon.ArcanaPylonEffectData;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;

public class ArcanaPylonBlockEntity
extends ObeliskCoreBlockEntity
implements IAltarAccelerator {
    public static final Supplier<MultiBlockStructure> STRUCTURE = () -> MultiBlockStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)MalumBlocks.ARCANA_PYLON_COMPONENT.get()).defaultBlockState())});
    private static final IAltarAccelerator.AltarAcceleratorType ARCANA_PYLON = new IAltarAccelerator.AltarAcceleratorType(4, "arcana_pylon");
    private static final HashMap<Holder<SpiritArcanaType>, RiteEffectHolder<? extends SpiritRiteEmpowermentEffect<?>>> RITE_EMPOWERMENT_EFFECTS = new HashMap<Holder<SpiritArcanaType>, RiteEffectHolder<? extends SpiritRiteEmpowermentEffect<?>>>(){
        {
            this.put(MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritRiteEffectTypes.EMPOWER_AERIAL_EFFECTS);
            this.put(MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritRiteEffectTypes.EMPOWER_AQUEOUS_EFFECTS);
            this.put(MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritRiteEffectTypes.EMPOWER_EARTHEN_EFFECTS);
            this.put(MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritRiteEffectTypes.EMPOWER_INFERNAL_EFFECTS);
        }
    };
    private static final Vec3 ITEM_OFFSET = new Vec3(0.5, 2.25, 0.5);
    private static final int WARMUP_DURATION = 20;
    protected LodestoneBlockEntityInventory inventory = MalumSpiritBlockEntityInventory.singleSpiritStack((LodestoneBlockEntity)this).onContentsChanged(this::updateSpirit);
    protected SpiritArcanaType spirit;
    protected int unspentSpiritFuel;
    protected int visualEffectStrength;
    protected int timer;

    public ArcanaPylonBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ObeliskCoreBlockEntity>)((BlockEntityType)MalumBlockEntities.ARCANA_PYLON.get()), STRUCTURE.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registryLookup) {
        this.inventory.save(registryLookup, compound);
        if (this.spirit != null) {
            this.spirit.save(compound);
        }
        compound.putInt("unspentSpiritFuel", this.unspentSpiritFuel);
        compound.putInt("visualEffectStrength", this.visualEffectStrength);
        compound.putInt("timer", this.timer);
        super.saveAdditional(compound, registryLookup);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        this.inventory.load(registries, compound);
        this.spirit = SpiritArcanaType.load(compound).orElse(null);
        this.unspentSpiritFuel = compound.getInt("unspentSpiritFuel");
        this.visualEffectStrength = compound.getInt("visualEffectStrength");
        this.timer = compound.getInt("timer");
        super.loadAdditional(compound, registries);
    }

    @Override
    public IAltarAccelerator.AltarAcceleratorType getAcceleratorType() {
        return ARCANA_PYLON;
    }

    @Override
    public float getAcceleration() {
        return 0.5f;
    }

    @Override
    public boolean canAccelerate() {
        return this.spirit != null && this.spirit.matches(MalumSpiritTypes.ARCANE_SPIRIT);
    }

    @Override
    public void completeSpiritInfusion(ServerLevel level) {
        if (this.canAccelerate()) {
            this.spendSpiritFuel(level, 16);
        }
    }

    @Override
    public void addParticles(SpiritAltarBlockEntity blockEntity, SpiritArcanaType activeSpiritType) {
        SpiritAltarParticleEffects.arcanaPylonParticles(this, blockEntity, this.spirit);
    }

    public ItemInteractionResult onUseWithItem(Player pPlayer, ItemStack pStack, InteractionHand pHand) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.inventory.interact(serverLevel, pPlayer, pHand);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onBreak(@Nullable Player player) {
        if (!this.level.isClientSide) {
            this.inventory.dumpItems(this.level, this.worldPosition);
        }
        super.onBreak(player);
    }

    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.spirit != null) {
                if (this.timer == 0) {
                    this.triggerPassiveEffects(serverLevel);
                    this.timer = 100;
                } else {
                    --this.timer;
                }
            }
        }
        if (this.spirit != null) {
            level = this.inventory.getStackInSlot(0).getItem();
            if (level instanceof SpiritShardItem) {
                SpiritShardItem item = (SpiritShardItem)level;
                if (this.level.isClientSide) {
                    SpiritLightSpecs.rotatingLightSpecs(this.level, this.getItemPos(), item, 0.55f, 2);
                }
            } else if (this.unspentSpiritFuel == 0 && this.visualEffectStrength > 0) {
                --this.visualEffectStrength;
                if (this.visualEffectStrength == 0) {
                    this.spirit = null;
                    this.setDirty();
                }
                return;
            }
            if (this.visualEffectStrength < 20) {
                ++this.visualEffectStrength;
            }
        }
    }

    public void updateSpirit() {
        Item item = this.inventory.getStackInSlot(0).getItem();
        if (item instanceof SpiritShardItem) {
            SpiritShardItem item2 = (SpiritShardItem)item;
            if (this.spirit != item2.getSpirit()) {
                this.unspentSpiritFuel = 0;
            }
            this.spirit = item2.getSpirit();
        }
    }

    public void triggerPassiveEffects(ServerLevel level) {
        RiteEffectHolder<? extends SpiritRiteEmpowermentEffect<?>> effectHolder;
        Holder<SpiritArcanaType> holder = this.spirit.getHolder();
        if (RITE_EMPOWERMENT_EFFECTS.containsKey(holder) && (effectHolder = RITE_EMPOWERMENT_EFFECTS.get(holder)) != null) {
            SpiritRiteEffect.RiteParameters params = SpiritRiteEffect.builder().setTotemHeight(2).build();
            SpiritRiteEmpowermentEffect effect = (SpiritRiteEmpowermentEffect)effectHolder.get();
            if (effect.triggerRiteEffect(level, this.worldPosition, this.spirit, params)) {
                this.spendSpiritFuel(level, 4);
            }
        }
    }

    public void spendSpiritFuel(ServerLevel level, int fuelPerSpirit) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = level;
            MalumParticleEffectTypes.ARCANA_PYLON_EATS_SPIRIT.createEffect(this.worldPosition).color(this.spirit).customData(new ArcanaPylonEffectData(this.unspentSpiritFuel == 0 ? 1.0f : 0.5f)).spawn(serverLevel);
        }
        if (this.unspentSpiritFuel == 0) {
            this.unspentSpiritFuel = fuelPerSpirit;
            this.inventory.getStackInSlot(0).shrink(1);
        }
        --this.unspentSpiritFuel;
        this.setDirty();
    }

    public LodestoneBlockEntityInventory getInventory() {
        return this.inventory;
    }

    public SpiritArcanaType getSpirit() {
        return this.spirit;
    }

    public float getGlowDelta() {
        return (float)this.visualEffectStrength / 20.0f;
    }

    public Vec3 getItemPos() {
        BlockPos blockPos = this.getBlockPos();
        Vec3 offset = this.getCentralItemOffset();
        return new Vec3((double)blockPos.getX() + offset.x, (double)blockPos.getY() + offset.y, (double)blockPos.getZ() + offset.z);
    }

    public Vec3 getCentralItemOffset() {
        return ITEM_OFFSET;
    }
}

