/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.redstone;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.block.curiosities.redstone.OpenStateBlockEntity;
import com.sammy.malum.common.payloads.waveform.SpiritDiodeVisualUpdatePayload;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class SpiritDiodeBlockEntity
extends OpenStateBlockEntity {
    public TimeIntervalType type = TimeIntervalType.REDSTONE_TICK;
    public int frequency = 20;
    public int cachedInputSignal = -1;
    public int outputSignal;
    public long visualStartTime;
    public int visualTransitionDuration;
    public int visualTransitionStart;
    public int visualTransitionEnd;

    public SpiritDiodeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SpiritDiodeInfo resetState() {
        return new SpiritDiodeInfo(this.type, this.frequency);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.type = TimeIntervalType.valueOf(pTag.getString("type"));
        this.frequency = pTag.getInt("frequency");
        this.cachedInputSignal = pTag.getInt("cachedInputSignal");
        this.outputSignal = pTag.getInt("outputSignal");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("type", this.type.name());
        tag.putInt("frequency", this.frequency);
        tag.putInt("cachedInputSignal", this.cachedInputSignal);
        tag.putInt("outputSignal", this.outputSignal);
    }

    public int getAdjustedFrequency() {
        return this.frequency * this.type.timeScale;
    }

    public int getOutputSignal() {
        return Mth.clamp((int)this.outputSignal, (int)0, (int)15);
    }

    public void updateVisuals(int outputSignal, int inputSignal, boolean isPowering) {
        this.outputSignal = outputSignal;
        this.cachedInputSignal = inputSignal;
        this.visualStartTime = this.getLevel().getGameTime();
        this.visualTransitionDuration = this.getAdjustedFrequency();
        this.visualTransitionStart = isPowering ? 0 : 1;
        this.visualTransitionEnd = 1 - this.visualTransitionStart;
    }

    public void updateAnimation(ServerLevel serverLevel, BlockPos pos, int inputSignal) {
        int outputSignal = this.getOutputSignal();
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SpiritDiodeVisualUpdatePayload(pos, outputSignal, inputSignal, outputSignal == 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static enum TimeIntervalType implements StringRepresentable
    {
        REDSTONE_TICK("redstone_tick", 0, 2),
        SECOND("second", 1, 20),
        MINUTE("minute", 2, 1200);

        public static final StringRepresentable.EnumCodec<TimeIntervalType> CODEC;
        final String name;
        final int id;
        final int timeScale;

        private TimeIntervalType(String name, int id, int timeScale) {
            this.name = name;
            this.id = id;
            this.timeScale = timeScale;
        }

        public String getName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public Component getText(SpiritDiodeBlockEntity blockEntity) {
            return this.getText(blockEntity.frequency > 1);
        }

        public Component getText(boolean plural) {
            String key = plural ? this.getPluralLangKey() : this.getLangKey();
            return Component.translatable((String)key);
        }

        public String getLangKey() {
            return "malum.waveform_artifice." + this.getName();
        }

        public String getPluralLangKey() {
            return this.getLangKey() + "_plural";
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TimeIntervalType::values);
        }
    }

    public record SpiritDiodeInfo(TimeIntervalType type, int frequency) implements OpenStateBlockEntity.InboundInfo<SpiritDiodeBlockEntity>
    {
        public static final Codec<SpiritDiodeInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TimeIntervalType.CODEC.fieldOf("type").forGetter(SpiritDiodeInfo::type), (App)Codec.INT.fieldOf("frequency").forGetter(SpiritDiodeInfo::frequency)).apply((Applicative)instance, SpiritDiodeInfo::new));
        public static StreamCodec<ByteBuf, SpiritDiodeInfo> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

        @Override
        public void sync(SpiritDiodeBlockEntity entity) {
            entity.type = this.type;
            entity.frequency = this.frequency;
        }
    }
}

