/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem.waveform;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlock;
import com.sammy.malum.common.block.curiosities.totem.waveform.WaveformTotemBaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class WaveformTotemBaseBlock<T extends WaveformTotemBaseBlockEntity>
extends TotemBaseBlock<T> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public WaveformTotemBaseBlock(BlockBehaviour.Properties properties, boolean corrupted) {
        super(properties, corrupted);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean flag = (Boolean)state.getValue((Property)POWERED);
            if (flag != level.hasNeighborSignal(pos)) {
                if (flag) {
                    level.scheduleTick(pos, (Block)this, 4);
                } else {
                    WaveformTotemBaseBlockEntity totemBase;
                    level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    if (blockEntity instanceof WaveformTotemBaseBlockEntity && (totemBase = (WaveformTotemBaseBlockEntity)blockEntity).canTriggerRite()) {
                        totemBase.triggerRite(serverLevel);
                    }
                }
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }
}

