/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.storage.jar;

import com.sammy.malum.common.block.storage.jar.SpiritJarBlockEntity;
import com.sammy.malum.registry.common.MalumSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.block.WaterLoggedEntityBlock;

public class SpiritJarBlock<T extends SpiritJarBlockEntity>
extends WaterLoggedEntityBlock<T> {
    public static final VoxelShape SHAPE = SpiritJarBlock.makeShape();

    public SpiritJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        this.handleAttack(pLevel, pPos, pPlayer);
    }

    public static void attack(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof SpiritJarBlock) {
            SpiritJarBlock jarBlock = (SpiritJarBlock)block;
            Player player = event.getEntity();
            BlockHitResult target = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (target.getType() == HitResult.Type.BLOCK && target.getBlockPos().equals((Object)pos) && target.getDirection().getAxis() == Direction.Axis.X && player.isCreative()) {
                event.setCanceled(jarBlock.handleAttack(level, pos, player));
            }
        }
    }

    public boolean handleAttack(Level pLevel, BlockPos pPos, Player pPlayer) {
        SpiritJarBlockEntity jar;
        IItemHandler jarHandler;
        ItemStack item;
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof SpiritJarBlockEntity && !(item = (jarHandler = (jar = (SpiritJarBlockEntity)be).getInventory(Direction.DOWN)).extractItem(0, pPlayer.isShiftKeyDown() ? 64 : 1, false)).isEmpty()) {
            ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)item, (int)pPlayer.getInventory().selected);
            if (!pLevel.isClientSide) {
                BlockStateHelper.updateAndNotifyState((Level)pLevel, (BlockPos)pPos);
            }
            SoundHelper.playSound((Entity)pPlayer, (SoundEvent)((SoundEvent)MalumSoundEvents.PEDESTAL_SPIRIT_PICKUP.get()), (SoundSource)SoundSource.BLOCKS, (float)0.7f, (float)RandomHelper.randomBetween((RandomSource)pPlayer.getRandom(), (float)0.8f, (float)1.2f));
            return true;
        }
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SpiritJarBlockEntity) {
            SpiritJarBlockEntity jar = (SpiritJarBlockEntity)blockEntity;
            return jar.contents != null ? jar.contents.getSpirit().getAnalogSignal() : 0;
        }
        return 0;
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.15625, (double)0.03125, (double)0.15625, (double)0.84375, (double)0.84375, (double)0.84375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.21875, (double)0.90625, (double)0.21875, (double)0.78125, (double)1.03125, (double)0.78125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.28125, (double)0.84375, (double)0.28125, (double)0.71875, (double)0.90625, (double)0.71875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.34375, (double)-0.03125, (double)0.34375, (double)0.65625, (double)0.09375, (double)0.65625), (BooleanOp)BooleanOp.OR);
        return shape;
    }
}

