/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.storage.pedestal;

import com.sammy.malum.common.block.storage.pedestal.ItemPedestalBlockEntity;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import team.lodestar.lodestone.systems.block.WaterLoggedEntityBlock;

public class ItemPedestalBlock<T extends ItemPedestalBlockEntity>
extends WaterLoggedEntityBlock<T> {
    public static final VoxelShape SHAPE = Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.box((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public ItemPedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof ItemPedestalBlockEntity) {
            ItemPedestalBlockEntity pedestal = (ItemPedestalBlockEntity)be;
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)pedestal.getInventory(Direction.UP));
        }
        return 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

