/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.container;

import com.sammy.malum.common.block.curiosities.weavers_workbench.WeaversWorkbenchBlockEntity;
import com.sammy.malum.common.block.curiosities.weavers_workbench.WeaversWorkbenchItemHandler;
import com.sammy.malum.registry.common.MalumContainers;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import team.lodestar.lodestone.systems.item.LodestoneArmorItem;

public class WeaversWorkbenchContainer
extends AbstractContainerMenu {
    public static final Component component = Component.literal((String)"Weaver's Workbench");
    public final WeaversWorkbenchItemHandler itemHandler;
    public final WeaversWorkbenchBlockEntity blockEntity;

    public WeaversWorkbenchContainer(int containerId, Inventory inv, RegistryFriendlyByteBuf data) {
        this(containerId, inv, ContainerLevelAccess.create((Level)inv.player.level(), (BlockPos)data.readBlockPos()));
    }

    public WeaversWorkbenchContainer(int containerId, Inventory playerInv) {
        this(containerId, playerInv, ContainerLevelAccess.NULL);
    }

    public WeaversWorkbenchContainer(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)MalumContainers.WEAVERS_WORKBENCH.get(), containerId);
        final Optional<WeaversWorkbenchBlockEntity> blockEntity = access.evaluate(Level::getBlockEntity).filter(b -> b instanceof WeaversWorkbenchBlockEntity).map(b -> (WeaversWorkbenchBlockEntity)((Object)b));
        this.itemHandler = blockEntity.map(b -> b.itemHandler).orElse(null);
        this.blockEntity = blockEntity.orElse(null);
        if (blockEntity.isPresent()) {
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.itemHandler, 0, 18, 52){

                public boolean mayPlace(ItemStack pStack) {
                    return pStack.getItem() instanceof LodestoneArmorItem;
                }
            });
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.itemHandler, 1, 54, 52){

                public boolean mayPlace(ItemStack pStack) {
                    return pStack.has(MalumDataComponents.ITEM_SKIN);
                }
            });
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.itemHandler, 2, 90, 52){

                public boolean mayPlace(ItemStack pStack) {
                    return false;
                }

                public void onTake(Player pPlayer, ItemStack pStack) {
                    super.onTake(pPlayer, pStack);
                    ((WeaversWorkbenchBlockEntity)((Object)blockEntity.get())).onCraft();
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 142));
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.itemHandler.getSlots() ? !this.moveItemStackTo(itemstack1, this.itemHandler.getSlots(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.itemHandler.getSlots(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
                slot.onTake(playerIn, itemstack1);
            } else {
                slot.setChanged();
            }
        }
        this.itemHandler.onContentsChanged(index);
        return itemstack;
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }
}

