/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.registry.common.item.MalumItems;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record SoulwovenBannerPatternDataComponent(ResourceLocation type, ResourceLocation texturePath, String translationKey) {
    public static Codec<SoulwovenBannerPatternDataComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("type").forGetter(SoulwovenBannerPatternDataComponent::type), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(SoulwovenBannerPatternDataComponent::texturePath)).apply((Applicative)instance, SoulwovenBannerPatternDataComponent::new));
    public static StreamCodec<ByteBuf, SoulwovenBannerPatternDataComponent> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    public static final List<SoulwovenBannerPatternDataComponent> REGISTERED_PATTERNS = new ArrayList<SoulwovenBannerPatternDataComponent>();
    public static final SoulwovenBannerPatternDataComponent DEFAULT = SoulwovenBannerPatternDataComponent.register("default");
    public static final SoulwovenBannerPatternDataComponent SACRED = SoulwovenBannerPatternDataComponent.register("sequence");
    public static final SoulwovenBannerPatternDataComponent WICKED = SoulwovenBannerPatternDataComponent.register("sword");
    public static final SoulwovenBannerPatternDataComponent ARCANE = SoulwovenBannerPatternDataComponent.register("spawn");
    public static final SoulwovenBannerPatternDataComponent ELDRITCH = SoulwovenBannerPatternDataComponent.register("sanity");
    public static final SoulwovenBannerPatternDataComponent AERIAL = SoulwovenBannerPatternDataComponent.register("breeze");
    public static final SoulwovenBannerPatternDataComponent AQUEOUS = SoulwovenBannerPatternDataComponent.register("breath");
    public static final SoulwovenBannerPatternDataComponent EARTHEN = SoulwovenBannerPatternDataComponent.register("break");
    public static final SoulwovenBannerPatternDataComponent INFERNAL = SoulwovenBannerPatternDataComponent.register("burn");
    public static final SoulwovenBannerPatternDataComponent HUNGER = SoulwovenBannerPatternDataComponent.register("hunger");
    public static final SoulwovenBannerPatternDataComponent HORNS = SoulwovenBannerPatternDataComponent.register("horns");
    public static final SoulwovenBannerPatternDataComponent HEFT = SoulwovenBannerPatternDataComponent.register("heft");
    public static final SoulwovenBannerPatternDataComponent HALLUCINATION = SoulwovenBannerPatternDataComponent.register("hallucination");
    public static final SoulwovenBannerPatternDataComponent COLORFUL_WORLD = SoulwovenBannerPatternDataComponent.register("colorful_world");

    public SoulwovenBannerPatternDataComponent(ResourceLocation type, ResourceLocation texturePath) {
        this(type, texturePath, Util.makeDescriptionId((String)"banner_pattern", (ResourceLocation)type));
    }

    public static SoulwovenBannerPatternDataComponent register(String type) {
        return SoulwovenBannerPatternDataComponent.register(MalumMod.malumPath(type));
    }

    public static SoulwovenBannerPatternDataComponent register(ResourceLocation type) {
        SoulwovenBannerPatternDataComponent pattern = new SoulwovenBannerPatternDataComponent(type, ResourceLocation.fromNamespaceAndPath((String)type.getNamespace(), (String)("textures/block/banners/soulwoven_banner_" + type.getPath() + ".png")));
        REGISTERED_PATTERNS.add(pattern);
        return pattern;
    }

    public ItemStack getDefaultStack() {
        ItemStack stack = ((Item)MalumItems.SOULWOVEN_BANNER.get()).getDefaultInstance();
        stack.set(MalumDataComponents.SOULWOVEN_BANNER_PATTERN, (Object)this);
        return stack;
    }

    public ResourceLocation getRecipeId() {
        return this.type().withPrefix("banner_crafting_");
    }

    public CompoundTag save(CompoundTag tag) {
        if (!this.equals(DEFAULT)) {
            tag.put("pattern", (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow());
        }
        return tag;
    }

    public static SoulwovenBannerPatternDataComponent load(@Nullable CompoundTag tag) {
        return tag != null && tag.contains("pattern") ? CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("pattern")).result().orElse(DEFAULT) : DEFAULT;
    }
}

