/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.activator;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.common.entity.FloatingItemDestinationData;
import com.sammy.malum.common.spiritrite.effect.aerial.BlockGravityRiteEffect;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumEntityDataSerializers;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.NBTHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;

public class SpellweaverToolEffectActivatorEntity
extends FloatingEntity {
    protected static final EntityDataAccessor<SpiritArcanaType> DATA_SPIRIT_GLOW = SynchedEntityData.defineId(SpellweaverToolEffectActivatorEntity.class, (EntityDataSerializer)((EntityDataSerializer)MalumEntityDataSerializers.SPIRIT_ARCANA.get()));
    public static SpellweaverToolEffectActivatorEntity BREAKER_ENTITY;
    protected ItemStack tool = ItemStack.EMPTY;
    protected UUID owner;
    protected float speed;
    protected List<ItemEntity> carriedItems = new ArrayList<ItemEntity>();
    protected List<BlockPos> backupPositions = new ArrayList<BlockPos>();
    protected int carriedExperience;

    public SpellweaverToolEffectActivatorEntity(Level level) {
        super((EntityType)MalumEntities.SPELLWEAVER_TOOL_EFFECT_ACTIVATOR.get(), level);
        this.maxAge = 4000;
    }

    public SpellweaverToolEffectActivatorEntity(Level level, ItemStack tool, UUID owner, float speed, BlockPos targetPos, Vec3 position, Vec3 velocity) {
        this(level);
        this.tool = tool;
        this.owner = owner;
        this.speed = speed;
        this.setDestination(new FloatingItemDestinationData(targetPos));
        this.setPos(position);
        this.setDeltaMovement(velocity);
        this.maxAge = 800;
    }

    public void addBackupPositions(List<BlockPos> backupPositions) {
        this.backupPositions.addAll(backupPositions);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SPIRIT_GLOW, (Object)((SpiritArcanaType)MalumSpiritTypes.ARCANE_SPIRIT.get()));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        SpiritArcanaType spirit = this.getSpiritType();
        if (spirit != null) {
            spirit.save(pCompound);
        }
        if (this.tool != null) {
            CompoundTag toolTag = new CompoundTag();
            this.tool.save((HolderLookup.Provider)this.registryAccess(), (Tag)toolTag);
            pCompound.put("tool", (Tag)toolTag);
        }
        pCompound.putUUID("ownerUUID", this.owner);
        pCompound.putFloat("speed", this.speed);
        if (!this.carriedItems.isEmpty()) {
            pCompound.putInt("carriedItemCount", this.carriedItems.size());
            for (int i = 0; i < this.carriedItems.size(); ++i) {
                ItemEntity entity = this.carriedItems.get(i);
                CompoundTag carriedTag = new CompoundTag();
                entity.save(carriedTag);
                pCompound.put("carriedItem_" + i, (Tag)carriedTag);
            }
        }
        pCompound.putInt("backupPositionCount", this.backupPositions.size());
        for (int i = 0; i < this.backupPositions.size(); ++i) {
            pCompound.put("backupPosition_" + i, (Tag)NBTHelper.saveBlockPos((BlockPos)this.backupPositions.get(i)));
        }
        pCompound.putInt("carriedExperience", this.carriedExperience);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        int i;
        super.readAdditionalSaveData(pCompound);
        this.setSpirit(SpiritArcanaType.load(pCompound).orElse((SpiritArcanaType)MalumSpiritTypes.ARCANE_SPIRIT.get()));
        CompoundTag toolTag = pCompound.getCompound("tool");
        this.tool = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)toolTag).orElse(ItemStack.EMPTY);
        this.carriedItems.clear();
        for (i = 0; i < pCompound.getInt("carriedItemCount"); ++i) {
            CompoundTag carriedTag = pCompound.getCompound("carriedItem_" + i);
            ItemEntity carriedItem = new ItemEntity(this.level(), 0.0, 0.0, 0.0, ItemStack.EMPTY);
            carriedItem.load(carriedTag);
            this.carriedItems.add(carriedItem);
        }
        this.owner = pCompound.getUUID("ownerUUID");
        this.speed = pCompound.getFloat("speed");
        this.backupPositions.clear();
        for (i = 0; i < pCompound.getInt("backupPositionCount"); ++i) {
            CompoundTag posTag = pCompound.getCompound("backupPosition_" + i);
            this.backupPositions.add(NBTHelper.readBlockPos((CompoundTag)posTag));
        }
        this.carriedExperience = pCompound.getInt("carriedExperience");
    }

    public boolean mayInteract(Level level, BlockPos pos) {
        return false;
    }

    @Override
    public boolean shouldVanishAfterCollection(ServerLevel level) {
        return this.destination.getTargetLocation().left().isPresent();
    }

    @Override
    public void collect(ServerLevel level) {
        DeferredHolder sound = (DeferredHolder)this.destination.getTargetLocation().map(u -> MalumSoundEvents.SPELLWOVEN_SPRITE_RETURNS, b -> MalumSoundEvents.SPELLWOVEN_SPRITE_HARVESTS);
        SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)sound.get()), (float)0.5f, (float)1.0f);
        this.destination.getTargetLocation().ifRight(pos -> {
            BlockState state = level.getBlockState(pos);
            if (state.isEmpty()) {
                this.discard();
                return;
            }
            ItemStack harvestToolStack = BlockGravityRiteEffect.getToolForState(state);
            if (harvestToolStack.isEmpty()) {
                this.discard();
                return;
            }
            Entity breaker = level.getEntity(this.owner);
            if (breaker == null) {
                this.discard();
                return;
            }
            BREAKER_ENTITY = this;
            BlockEntity blockentity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
            level.levelEvent(2001, pos, Block.getId((BlockState)level.getBlockState(pos)));
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)blockentity, (Entity)breaker, (ItemStack)this.tool);
            this.destination = new FloatingItemDestinationData(this.owner);
            this.carriedExperience = EnchantmentHelper.processBlockExperience((ServerLevel)level, (ItemStack)this.tool, (int)state.getExpDrop((LevelAccessor)level, pos, blockentity, breaker, this.tool));
            BREAKER_ENTITY = null;
            this.movementWindUp = this.speed < 1.0f ? 0 : Mth.ceil((float)((float)this.movementWindUp / this.speed));
        }).ifLeft(uuid -> {
            Entity entity = level.getEntity(uuid);
            Vec3 position = entity != null ? entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0) : this.getOffsetPosition();
            for (ItemEntity itemEntity : this.carriedItems) {
                itemEntity.setPickUpDelay(0);
                itemEntity.setPos(position);
                itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().multiply(0.0, 1.0, 0.0));
                level.addFreshEntity((Entity)itemEntity);
            }
            ExperienceOrb.award((ServerLevel)level, (Vec3)position, (int)this.carriedExperience);
        });
    }

    public static void redirectDrops(BlockDropsEvent event) {
        if (BREAKER_ENTITY != null) {
            SpellweaverToolEffectActivatorEntity.BREAKER_ENTITY.carriedItems.addAll(event.getDrops());
            event.setCanceled(true);
        }
    }

    @Override
    public void tick() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            BlockPos pos;
            BlockState state;
            Optional optional;
            ServerLevel level2 = (ServerLevel)level;
            if (this.tool.isEmpty()) {
                this.discard();
                return;
            }
            if (!this.backupPositions.isEmpty() && (optional = this.destination.getTargetLocation().right()).isPresent() && (state = level2.getBlockState(pos = (BlockPos)optional.get())).isEmpty()) {
                int roll = this.random.nextInt(this.backupPositions.size());
                BlockPos newTarget = this.backupPositions.get(roll);
                this.setDestination(new FloatingItemDestinationData(newTarget));
                this.backupPositions.remove(roll);
            }
            float windUpDuration = this.getWindUpDuration();
            float delta = Mth.clamp((float)((float)this.movementWindUp / windUpDuration), (float)0.0f, (float)1.0f);
            double length = this.getDeltaMovement().length();
            float disharmony = 0.25f * (1.0f - delta) / Math.max(this.speed, 0.1f);
            Vec3 addedOffset = new Vec3((double)RandomHelper.randomBetween((RandomSource)this.random, (float)(-disharmony), (float)disharmony), (double)RandomHelper.randomBetween((RandomSource)this.random, (float)(-disharmony), (float)disharmony), (double)RandomHelper.randomBetween((RandomSource)this.random, (float)(-disharmony), (float)disharmony));
            Vec3 newMovement = this.getDeltaMovement().add(addedOffset).normalize().scale(length);
            this.setDeltaMovement(newMovement);
        }
        super.tick();
        if (this.level().isClientSide) {
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.level(), this.getOffsetPosition(), this.getSpiritType());
            lightSpecs.getBuilder().modifyScaleData(d -> d.multiplyValue(0.75f)).multiplyLifetime(0.75f);
            lightSpecs.getBloomBuilder().multiplyLifetime(0.5f);
            lightSpecs.spawnParticles();
        }
    }

    @Override
    public int getWindUpDuration() {
        return Mth.clamp((int)Mth.floor((float)(40.0f - this.speed * 10.0f)), (int)10, (int)40);
    }

    @Override
    public float getFriction() {
        return 0.9f;
    }

    @Override
    public float getMovementSpeed(float windUp, float distance) {
        return 0.4f + Easing.EXPO_OUT.ease(windUp, 0.0f, 1.6f + this.speed * 0.4f);
    }

    @Override
    public float getMovementEasing(float windUp, float distance) {
        return 0.1f + Easing.EXPO_IN.ease(windUp, 0.0f, 0.4f);
    }

    public SpiritArcanaType getSpiritType() {
        return (SpiritArcanaType)this.getEntityData().get(DATA_SPIRIT_GLOW);
    }

    public void setSpirit(SpiritArcanaType spirit) {
        this.getEntityData().set(DATA_SPIRIT_GLOW, (Object)spirit);
    }

    public UUID getOwner() {
        return this.owner;
    }
}

