/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.staff.BoltImpactParticleEffect;
import java.util.Comparator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class AbstractBoltProjectileEntity
extends ThrowableItemProjectile {
    protected static final EntityDataAccessor<Boolean> DATA_FADING_AWAY = SynchedEntityData.defineId(AbstractBoltProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> DATA_SPAWN_DELAY = SynchedEntityData.defineId(AbstractBoltProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public TrailPointBuilder trailPointBuilder = TrailPointBuilder.create((int)8);
    public TrailPointBuilder spinningTrailPointBuilder = TrailPointBuilder.create((int)16);
    public float spinOffset = (float)((double)this.random.nextFloat() * Math.PI * 2.0);
    protected float magicDamage;
    public boolean isHoming;
    public int age;
    public int spawnDelay;
    public boolean fadingAway;
    public int fadingTimer;
    private LivingEntity homingTarget;

    public AbstractBoltProjectileEntity(EntityType<? extends AbstractBoltProjectileEntity> pEntityType, Level level) {
        super(pEntityType, level);
        this.noPhysics = false;
    }

    public void setData(LivingEntity owner, float magicDamage, int spawnDelay) {
        this.setOwner((Entity)owner);
        this.magicDamage = magicDamage;
        this.getEntityData().set(DATA_SPAWN_DELAY, (Object)spawnDelay);
        if (!this.level().isClientSide && spawnDelay == 0) {
            this.playSound((SoundEvent)MalumSoundEvents.STAFF_FIRES.get(), 0.5f, Mth.nextFloat((RandomSource)this.random, (float)0.9f, (float)1.5f));
        }
        this.isHoming = GeasEffectHandler.hasGeasEffect(owner, MalumGeasEffectTypes.OATH_OF_THE_OVERKEEN_EYE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void spawnParticles();

    public abstract int getMaxAge();

    public abstract BoltImpactParticleEffect getImpactParticleEffect();

    public abstract MalumNetworkedParticleEffectColorData getImpactParticleColor();

    public float getOrbitingTrailDistance() {
        return 0.3f;
    }

    public void onDealDamage(LivingEntity target) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_FADING_AWAY, (Object)false);
        builder.define(DATA_SPAWN_DELAY, (Object)0);
        super.defineSynchedData(builder);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (DATA_FADING_AWAY.equals(pKey)) {
            this.fadingAway = (Boolean)this.entityData.get(DATA_FADING_AWAY);
            if (this.fadingAway) {
                this.age = this.getMaxAge() - 10;
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.02f));
            }
        }
        if (DATA_SPAWN_DELAY.equals(pKey)) {
            this.spawnDelay = (Integer)this.entityData.get(DATA_SPAWN_DELAY);
        }
        super.onSyncedDataUpdated(pKey);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.magicDamage != 0.0f) {
            compound.putFloat("magicDamage", this.magicDamage);
        }
        if (this.isHoming) {
            compound.putBoolean("isHoming", true);
        }
        if (this.age != 0) {
            compound.putInt("age", this.age);
        }
        if (this.spawnDelay != 0) {
            compound.putInt("spawnDelay", this.spawnDelay);
        }
        if (this.fadingAway) {
            compound.putBoolean("fadingAway", true);
            compound.putInt("fadingTimer", this.fadingTimer);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.magicDamage = compound.getFloat("magicDamage");
        this.isHoming = compound.getBoolean("isHoming");
        this.age = compound.getInt("age");
        this.getEntityData().set(DATA_SPAWN_DELAY, (Object)compound.getInt("spawnDelay"));
        this.getEntityData().set(DATA_FADING_AWAY, (Object)compound.getBoolean("fadingAway"));
    }

    protected void onHitBlock(BlockHitResult pResult) {
        if (this.fadingAway || this.spawnDelay > 0) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnEffect(serverLevel, 0.25f);
            this.playSound((SoundEvent)MalumSoundEvents.STAFF_STRIKES.get(), 0.5f, Mth.nextFloat((RandomSource)this.random, (float)0.9f, (float)1.5f));
            this.getEntityData().set(DATA_FADING_AWAY, (Object)true);
            Vec3 direction = pResult.getLocation().subtract(this.position());
            Vec3 offset = direction.normalize().scale(0.5);
            this.setPosRaw(this.getX() - offset.x, this.getY() - offset.y, this.getZ() - offset.z);
        }
        super.onHitBlock(pResult);
    }

    protected boolean canHitEntity(Entity pTarget) {
        if (pTarget.equals((Object)this.getOwner())) {
            return false;
        }
        if (pTarget instanceof AbstractBoltProjectileEntity) {
            return false;
        }
        return super.canHitEntity(pTarget);
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.fadingAway || this.spawnDelay > 0) {
                return;
            }
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity staffOwner = (LivingEntity)entity;
                Entity target = result.getEntity();
                target.invulnerableTime = 0;
                DamageSource source = DamageTypeHelper.create((Level)this.level(), MalumDamageTypes.VOODOO, (Entity)this, (Entity)staffOwner);
                boolean success = target.hurt(source, this.magicDamage);
                if (success && target instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)target;
                    this.onDealDamage(livingentity);
                    this.spawnEffect(serverLevel, 0.5f);
                    this.playSound((SoundEvent)MalumSoundEvents.STAFF_STRIKES.get(), 0.75f, Mth.nextFloat((RandomSource)this.random, (float)1.0f, (float)1.4f));
                    this.setDeltaMovement(this.getDeltaMovement().scale((double)0.05f));
                    this.getEntityData().set(DATA_FADING_AWAY, (Object)true);
                }
            }
        }
        super.onHitEntity(result);
    }

    public void tick() {
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            if (this.spawnDelay == 0 && !this.level().isClientSide) {
                this.playSound((SoundEvent)MalumSoundEvents.STAFF_FIRES.get(), 1.0f, Mth.nextFloat((RandomSource)this.random, (float)0.9f, (float)1.5f));
            }
            return;
        }
        super.tick();
        ++this.age;
        if (this.fadingAway) {
            ++this.fadingTimer;
        } else {
            Vec3 motion = this.getDeltaMovement();
            float scalar = 0.96f;
            this.setDeltaMovement(motion.x * (double)scalar, (motion.y - (double)0.02f) * (double)scalar, motion.z * (double)scalar);
        }
        if (this.isHoming) {
            this.homeIn();
        }
        if (this.level().isClientSide) {
            float offsetScale = this.fadingAway ? 0.0f : this.getOrbitingTrailDistance();
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.getPosition(progress);
                float scalar = ((float)this.age + progress) / 2.0f;
                double xOffset = Math.cos(this.spinOffset + scalar) * (double)offsetScale;
                double zOffset = Math.sin(this.spinOffset + scalar) * (double)offsetScale;
                this.trailPointBuilder.addTrailPoint(position);
                this.spinningTrailPointBuilder.addTrailPoint(position.add(xOffset, 0.0, zOffset));
            }
            this.trailPointBuilder.tickTrailPoints();
            this.spinningTrailPointBuilder.tickTrailPoints();
            if (!this.fadingAway) {
                this.spawnParticles();
            }
        } else if (this.age >= this.getMaxAge()) {
            if (this.fadingAway) {
                this.discard();
            } else {
                this.getEntityData().set(DATA_FADING_AWAY, (Object)true);
            }
        }
    }

    public SoundSource getSoundSource() {
        return this.getOwner() != null ? this.getOwner().getSoundSource() : SoundSource.PLAYERS;
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.getOwner() != null && this.position().distanceTo(this.getOwner().position()) < 2.0) {
            SoundHelper.playSound((Entity)this.getOwner(), (SoundEvent)sound, (float)volume, (float)pitch);
            return;
        }
        super.playSound(sound, volume, pitch);
    }

    public void homeIn() {
        Vec3 motion = this.getDeltaMovement();
        Entity owner = this.getOwner();
        if (this.spawnDelay > 0 || owner == null || this.fadingAway) {
            return;
        }
        if (this.homingTarget == null || this.homingTarget.isDeadOrDying()) {
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(50.0), target -> target != owner && target.isAlive() && !target.isAlliedTo(owner) && this.hasLineOfSight((Entity)target));
            if (entities.isEmpty()) {
                return;
            }
            Vec3 angle = this.getDeltaMovement().normalize();
            this.homingTarget = entities.stream().max(Comparator.comparingDouble(e -> e.position().subtract(this.position()).normalize().dot(angle))).get();
        }
        if (this.homingTarget != null) {
            Vec3 targetPosition = this.homingTarget.position().add(0.0, (double)(this.homingTarget.getBbHeight() / 2.0f), 0.0);
            Vec3 diff = targetPosition.subtract(this.position());
            double speed = motion.length();
            Vec3 nextPosition = this.position().add(this.getDeltaMovement());
            if (this.homingTarget.distanceToSqr(nextPosition) > this.homingTarget.distanceToSqr(this.position())) {
                this.homingTarget = null;
                return;
            }
            float dot = (float)motion.normalize().dot(diff.normalize());
            if (dot < 0.0f) {
                this.homingTarget = null;
                return;
            }
            Vec3 newMotion = diff.normalize().scale(speed);
            if (newMotion.length() == 0.0) {
                newMotion = newMotion.add(0.01, 0.0, 0.0);
            }
            float angleScalar = Math.max(dot * 2.0f, 0.6f);
            float factor = 0.1f * angleScalar;
            double x = Mth.clampedLerp((double)motion.x, (double)newMotion.x, (double)factor);
            double y = Mth.clampedLerp((double)motion.y, (double)newMotion.y, (double)factor);
            double z = Mth.clampedLerp((double)motion.z, (double)newMotion.z, (double)factor);
            this.setDeltaMovement(new Vec3(x, y, z));
        }
    }

    public void spawnEffect(ServerLevel level, float offset) {
        this.getImpactParticleEffect().createEffect(this.position().add(this.getDeltaMovement().scale((double)offset))).color(this.getImpactParticleColor()).customData(new BoltImpactParticleEffect.BoltImpactEffectData(this.getDeltaMovement().reverse().normalize())).spawn(level);
    }

    public void shootFromRotation(Entity shooter, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float innacuracy) {
        float f = -Mth.sin((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, innacuracy);
    }

    public boolean hasLineOfSight(Entity target) {
        Vec3 wrathPosition = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 targetPosition = new Vec3(target.getX(), target.getEyeY(), target.getZ());
        BlockHitResult clipResult = this.level().clip(new ClipContext(wrathPosition, targetPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return clipResult.getType().equals((Object)HitResult.Type.MISS);
    }

    public float getVisualEffectScalar() {
        float effectScalar = 1.0f;
        if (this.age < 8) {
            effectScalar = (float)this.age / 8.0f;
        } else if (this.fadingAway) {
            effectScalar /= (float)(this.fadingTimer + 2) / 2.0f;
        }
        return effectScalar;
    }

    public boolean isNoGravity() {
        return true;
    }

    public float getPickRadius() {
        return 4.0f;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }
}

