/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.nitrate;

import com.sammy.malum.common.entity.nitrate.AbstractNitrateEntity;
import com.sammy.malum.registry.common.MalumDamageTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class NitrateExplosion
extends Explosion {
    public NitrateExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Explosion.BlockInteraction blockInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, Holder<SoundEvent> explosionSound) {
        super(level, source, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction, smallExplosionParticles, largeExplosionParticles, explosionSound);
    }

    public static void processExplosion(ExplosionEvent.Detonate event) {
        if (event.getExplosion() instanceof NitrateExplosion) {
            event.getAffectedEntities().removeIf(e -> {
                Player player;
                return e instanceof AbstractNitrateEntity || e instanceof Player && (player = (Player)e).isCreative();
            });
        }
    }

    public static NitrateExplosion explode(Level level, @Nullable Entity source, double x, double y, double z, float radius) {
        return NitrateExplosion.explode(level, source, null, x, y, z, radius);
    }

    public static NitrateExplosion explode(Level level, @Nullable Entity source, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius) {
        return NitrateExplosion.explode(level, source, damageCalculator, x, y, z, radius, true);
    }

    public static NitrateExplosion explode(Level level, @Nullable Entity source, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean spawnParticles) {
        DamageSource damageSource = DamageTypeHelper.create((Level)level, source != null ? MalumDamageTypes.NITRATE : MalumDamageTypes.NITRATE_PLAYERLESS, (Entity)source);
        NitrateExplosion explosion = new NitrateExplosion(level, source, damageSource, damageCalculator, x, y, z, radius, false, level.getGameRules().getBoolean(GameRules.RULE_TNT_EXPLOSION_DROP_DECAY) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder<SoundEvent>)SoundEvents.GENERIC_EXPLODE);
        if (EventHooks.onExplosionStart((Level)level, (Explosion)explosion)) {
            return explosion;
        }
        explosion.explode();
        explosion.finalizeExplosion(spawnParticles);
        return explosion;
    }
}

