/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WindNucleusItem
extends Item {
    public static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.of(Float.valueOf(3.0f)), BuiltInRegistries.BLOCK.getTag(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));

    public WindNucleusItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        float radius = 1.5f;
        float addedMotion = 2.0f;
        Vec3 pos = player.getEyePosition().add(player.getLookAngle().scale(3.0));
        level.explode((Entity)player, null, EXPLOSION_DAMAGE_CALCULATOR, pos.x(), pos.y(), pos.z(), radius, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST, (ParticleOptions)ParticleTypes.GUST, (Holder)SoundEvents.WIND_CHARGE_BURST);
        List<Entity> explosionAffectedEntities = WindNucleusItem.getExplosionAffectedEntities(level, (Entity)player, pos, radius);
        for (Entity entity : explosionAffectedEntities) {
            Vec3 movement = entity.getDeltaMovement();
            entity.setDeltaMovement(player.getLookAngle().normalize().scale(Math.max(movement.length(), (double)addedMotion)));
        }
        ItemStack itemstack = player.getItemInHand(usedHand);
        player.getCooldowns().addCooldown((Item)this, 10);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        itemstack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.success((Object)itemstack);
    }

    public static List<Entity> getExplosionAffectedEntities(Level level, @Nullable Entity ignored, Vec3 pos, float radius) {
        float f2 = radius * 2.0f;
        int k1 = Mth.floor((double)(pos.x - (double)f2 - 1.0));
        int l1 = Mth.floor((double)(pos.x + (double)f2 + 1.0));
        int i2 = Mth.floor((double)(pos.y - (double)f2 - 1.0));
        int i1 = Mth.floor((double)(pos.y + (double)f2 + 1.0));
        int j2 = Mth.floor((double)(pos.z - (double)f2 - 1.0));
        int j1 = Mth.floor((double)(pos.z + (double)f2 + 1.0));
        return level.getEntities(ignored, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
    }
}

