/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.spirit;

import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.visual_effects.ScreenParticleEffects;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.handlers.screenparticle.ParticleEmitterHandler;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;

public class SpiritShardItem
extends Item
implements ParticleEmitterHandler.ItemParticleSupplier,
SpiritLike {
    protected final SpiritHolder<SpiritArcanaType> spirit;
    protected Component flavorText;

    public SpiritShardItem(Item.Properties properties, SpiritHolder<SpiritArcanaType> spirit) {
        super(properties);
        this.spirit = spirit;
    }

    @Override
    @NotNull
    public SpiritArcanaType getSpirit() {
        return this.spirit.getSpirit();
    }

    public SpiritHolder<SpiritArcanaType> getSpiritHolder() {
        return this.spirit;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        SpiritHolder<SpiritArcanaType> spirit = this.getSpiritHolder();
        if (this.flavorText == null) {
            this.flavorText = Component.translatable((String)spirit.getFlavourKey()).withStyle(ChatFormatting.ITALIC).withStyle(spirit.getStyle(true));
        }
        tooltipComponents.add(this.flavorText);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        ScreenParticleEffects.spawnSpiritShardScreenParticles(target, this.spirit);
    }
}

