/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.aerial;

import com.sammy.malum.common.entity.AscendingBlockEntity;
import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.common.spiritrite.effect.aerial.BlockGravityRiteEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.helpers.RandomHelper;

public class BlockAscensionRiteEffect
extends SpiritRiteBlockEffect {
    public BlockAscensionRiteEffect() {
        super(SpiritRiteEffectTag.GREATER_RITE);
    }

    @Override
    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity entity, BlockState state, BlockPos pos, float impact) {
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        if ((FallingBlock.isFree((BlockState)stateAbove) || !stateAbove.canOcclude() || stateAbove.is(BlockTags.SLABS)) && !state.isAir() && level.getBlockEntity(pos) == null && BlockGravityRiteEffect.canSilkTouch(level, pos, state)) {
            AscendingBlockEntity.rise((Level)level, pos, state, 50.0f * impact);
            this.createEffect(level, MalumParticleEffectTypes.BLOCK_RITE_EFFECT, pos, MalumSpiritTypes.AERIAL_SPIRIT);
            level.playSound(null, pos, (SoundEvent)MalumSoundEvents.TOTEM_BLOCK_GRAVITY.get(), SoundSource.BLOCKS, 0.5f, RandomHelper.randomBetween((RandomSource)level.random, (float)1.75f, (float)2.0f));
        }
    }
}

