/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.arcane;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.common.recipe.UnchainedTransmutationRecipe;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class UnchainedRiteEffect
extends SpiritRiteBlockEffect {
    public UnchainedRiteEffect() {
        super(SpiritRiteEffectTag.GREATER_RITE);
    }

    @Override
    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity entity, BlockState state, BlockPos pos, float impact) {
        Item item;
        if (!state.is(MalumTags.BlockTags.UNCHAINED_RITE_CATALYST)) {
            entity.discard();
            return;
        }
        BlockPos targetPos = pos.above();
        BlockState targetState = level.getBlockState(targetPos);
        ItemStack targetAsItem = targetState.getBlock().asItem().getDefaultInstance();
        UnchainedTransmutationRecipe recipe = (UnchainedTransmutationRecipe)LodestoneRecipeType.getRecipe((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.UNCHAINED_TRANSMUTATION.get()), (RecipeInput)new SingleRecipeInput(targetAsItem));
        if (recipe != null && (item = recipe.output.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block resultBlock = blockItem.getBlock();
            BlockState newState = BlockStateHelper.setBlockStateWithExistingProperties((Level)level, (BlockPos)targetPos, (BlockState)resultBlock.defaultBlockState(), (int)3);
            level.levelEvent(2001, targetPos, Block.getId((BlockState)newState));
            this.createEffect(level, targetPos, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT);
            if (resultBlock instanceof EntityBlock) {
                BlockEntity newEntity;
                EntityBlock entityBlock = (EntityBlock)resultBlock;
                BlockEntity blockEntity = level.getBlockEntity(targetPos);
                if (blockEntity != null && (newEntity = entityBlock.newBlockEntity(pos, newState)) != null && newEntity.getClass().equals(blockEntity.getClass())) {
                    level.setBlockEntity(blockEntity);
                }
            }
        }
    }
}

