/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.sacred;

import com.sammy.malum.common.spiritrite.effect.sacred.NurturingEffectActor;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.HashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.allay.Allay;

public class NurturingEffect
extends SpiritRiteEntityEffect<Mob> {
    public static final HashMap<Class<? extends Mob>, NurturingEffectActor<?>> ACTORS = new HashMap();

    public NurturingEffect() {
        super(SpiritRiteEffectTag.GREATER_RITE);
    }

    @Override
    public Class<Mob> getTargetClass() {
        return Mob.class;
    }

    @Override
    public void applyEffect(ServerLevel level, Mob target) {
        NurturingEffectActor<?> actor;
        Animal animal;
        boolean success = false;
        if (target instanceof Animal && (animal = (Animal)target).getAge() < 0 && level.getRandom().nextFloat() <= 0.04f) {
            animal.ageUp(25);
            success = true;
        }
        if ((actor = ACTORS.get(target.getClass())) != null) {
            success = actor.tryAct(level, (LivingEntity)target);
        }
        if (success) {
            this.createEffect(level, target, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT);
        }
    }

    static {
        ACTORS.put(Sheep.class, NurturingEffectActor.SHEEP);
        ACTORS.put(Bee.class, NurturingEffectActor.BEE);
        ACTORS.put(Chicken.class, NurturingEffectActor.CHICKEN);
        ACTORS.put(Allay.class, NurturingEffectActor.ALLAY);
    }
}

