/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.wicked;

import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class HurtEffect
extends SpiritRiteEntityEffect<LivingEntity> {
    public HurtEffect() {
        super(List.of(SpiritRiteEffectTag.LESSER_RITE));
    }

    @Override
    public Class<LivingEntity> getTargetClass() {
        return LivingEntity.class;
    }

    @Override
    public void applyEffect(ServerLevel level, LivingEntity target) {
        DamageSource damageSource = DamageTypeHelper.create((Level)target.level(), MalumDamageTypes.VOODOO_PLAYERLESS);
        target.hurt(damageSource, 2.0f);
        this.createEffect(level, target, MalumSpiritTypes.WICKED_SPIRIT);
    }

    @Override
    public boolean canApplyEffect(ServerLevel level, LivingEntity target) {
        DamageSource damageSource = DamageTypeHelper.create((Level)target.level(), MalumDamageTypes.VOODOO_PLAYERLESS);
        if (target.getHealth() > 2.5f) {
            return !target.isInvulnerableTo(damageSource);
        }
        return false;
    }
}

