/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.wicked;

import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class MonsterRaisingEffect
extends SpiritRiteEntityEffect<Monster> {
    public MonsterRaisingEffect() {
        super(List.of(SpiritRiteEffectTag.GREATER_RITE));
    }

    @Override
    public Class<Monster> getTargetClass() {
        return Monster.class;
    }

    @Override
    public void applyEffect(ServerLevel level, Monster target) {
        DamageSource damageSource = DamageTypeHelper.create((Level)level, MalumDamageTypes.VOODOO_PLAYERLESS);
        target.hurt(damageSource, target.getMaxHealth() * 2.0f);
        this.createEffect(level, target, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT);
    }

    @Override
    public boolean canApplyEffect(ServerLevel level, Monster target) {
        DamageSource damageSource = DamageTypeHelper.create((Level)level, MalumDamageTypes.VOODOO_PLAYERLESS);
        if (target.isInvulnerableTo(damageSource)) {
            return false;
        }
        return target.getHealth() < target.getMaxHealth() * 0.1f;
    }
}

