/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compat.kubejs.component;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.MalumSoundEvents;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public record SoundEventHolderJSComponent(RecipeComponentType<?> type) implements RecipeComponent<Holder<SoundEvent>>
{
    private final RecipeComponentType<?> type;
    public static final RecipeComponentType<Holder<SoundEvent>> SOUND_HOLDER = RecipeComponentType.unit((ResourceLocation)MalumMod.malumPath("runic_workbench_sound"), SoundEventHolderJSComponent::new);

    public RecipeComponentType<?> type() {
        return SOUND_HOLDER;
    }

    public Codec<Holder<SoundEvent>> codec() {
        return SoundEvent.CODEC;
    }

    public TypeInfo typeInfo() {
        return TypeInfo.of(SoundEvents.NOTE_BLOCK_XYLOPHONE.getClass());
    }

    @Override
    public String toString() {
        return this.type().id().getPath();
    }

    public Holder<SoundEvent> wrap(RecipeScriptContext cx, Object from) {
        if (from instanceof JsonObject) {
            JsonObject json = (JsonObject)from;
            return (Holder)((Pair)this.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElseThrow()).getFirst();
        }
        return SoundEventHolderJSComponent.fromObject(RegistryAccessContainer.of((Context)cx.cx()), from);
    }

    public static Holder<SoundEvent> fromObject(RegistryAccessContainer registries, Object from) {
        if (from instanceof CharSequence) {
            try {
                return SoundEventHolderJSComponent.read(new StringReader(from.toString()));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to read Runic Workbench Sound from string: " + String.valueOf(from), exception);
            }
        }
        throw new IllegalArgumentException("Can't create Runic Workbench Sound from object: " + String.valueOf(from));
    }

    public static Holder<SoundEvent> read(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            return MalumSoundEvents.RUNIC_WORKBENCH_SHAPES_RUNE_GENERIC;
        }
        reader.skipWhitespace();
        String string = reader.readString();
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)string));
        return (Holder)BuiltInRegistries.SOUND_EVENT.getHolder(key).orElseThrow();
    }
}

