/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.enchantment;

import com.sammy.malum.common.entity.scythe.ScytheBoomerangEntity;
import com.sammy.malum.common.item.curiosities.TemporarilyDisabledItem;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.enchantment.EnchantmentKeys;
import com.sammy.malum.registry.common.item.MalumItems;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;

public class ReboundHandler {
    public static void throwScythe(Level level, Player player, InteractionHand hand, ItemStack scythe) {
        int slot;
        int n = slot = hand == InteractionHand.OFF_HAND ? player.getInventory().getContainerSize() - 1 : player.getInventory().selected;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean isEnhanced = MalumScytheItem.isEnhanced((LivingEntity)player);
            boolean isMaelstrom = CurioHelper.hasCurioEquipped((LivingEntity)player, (Item)((Item)MalumItems.RING_OF_THE_HOWLING_MAELSTROM.get()));
            float baseDamage = (float)player.getAttributes().getValue(Attributes.ATTACK_DAMAGE);
            float magicDamage = (float)player.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
            float velocity = isEnhanced ? 3.0f : 1.75f;
            Vec3 position = player.position().add(0.0, (double)(player.getBbHeight() * 0.5f), 0.0);
            if (isEnhanced) {
                int angle = hand == InteractionHand.MAIN_HAND ? 225 : 90;
                double radians = Math.toRadians((float)angle - player.yHeadRot);
                position = player.position().add(player.getLookAngle().scale(0.5)).add(0.75 * Math.sin(radians), (double)(player.getBbHeight() * 0.9f), 0.75 * Math.cos(radians));
                baseDamage *= 1.3f;
                magicDamage *= 1.3f;
            }
            ScytheBoomerangEntity entity = new ScytheBoomerangEntity(level, position.x, position.y, position.z);
            entity.setData((Entity)player, baseDamage, magicDamage, slot, 8);
            entity.setItem(scythe);
            entity.setNarrow(isEnhanced);
            entity.setMaelstrom(isMaelstrom);
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, velocity, 0.0f);
            level.addFreshEntity((Entity)entity);
            SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)MalumSoundEvents.SCYTHE_THROW.get()), (float)0.5f, (float)RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)0.75f, (float)1.25f));
            TemporarilyDisabledItem.disable(serverPlayer, slot, MalumItems.SOUL_OF_A_SCYTHE);
        }
        player.swing(hand, false);
        player.awardStat(Stats.ITEM_USED.get((Object)scythe.getItem()));
    }

    public static void pickupScythe(ScytheBoomerangEntity entity, ItemStack stack, ServerPlayer player) {
        if (!player.isCreative()) {
            int enchantmentLevel = EnchantmentKeys.getEnchantmentLevel(player.level(), EnchantmentKeys.REBOUND, stack);
            int cooldown = 120 - 35 * (enchantmentLevel - 1);
            if (entity.isMaelstrom()) {
                cooldown = (cooldown + 30) * 2;
            }
            player.getCooldowns().addCooldown(stack.getItem(), cooldown);
        }
        TemporarilyDisabledItem.enable(player, entity.slot);
    }
}

