/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.artifice;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.data.component.ArtificeAugmentDataComponent;
import com.sammy.malum.common.item.augment.ImpurityStabilizer;
import com.sammy.malum.common.item.augment.core.CausticCatalystItem;
import com.sammy.malum.common.item.augment.core.ResonanceTuner;
import com.sammy.malum.core.systems.artifice.AppliedTuningType;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeType;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeValue;
import com.sammy.malum.core.systems.artifice.ArtificeInfluenceData;
import com.sammy.malum.core.systems.artifice.ArtificeModifier;
import com.sammy.malum.core.systems.artifice.ArtificeModifierSourceInstance;
import com.sammy.malum.core.systems.artifice.IArtificeAcceptor;
import com.sammy.malum.core.systems.artifice.TuningModifier;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;

public class ArtificeAttributeData {
    public static Codec<ArtificeAttributeData> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)ArtificeAttributeValue.CODEC.listOf().fieldOf("attributes").forGetter(v -> v.attributes), (App)BlockPos.CODEC.listOf().fieldOf("modifierPositions").forGetter(v -> v.modifierPositions), (App)ArtificeAttributeType.CODEC.optionalFieldOf("tunedAttribute").forGetter(v -> Optional.ofNullable(v.tunedAttribute)), (App)Codec.BOOL.fieldOf("demandsFuel").forGetter(v -> v.demandsFuel), (App)Codec.FLOAT.fieldOf("chainProcessingBonus").forGetter(v -> Float.valueOf(v.chainProcessingBonus)), (App)Codec.INT.fieldOf("sympathyDamageStacks").forGetter(v -> v.sympathyDamageStacks), (App)Codec.FLOAT.fieldOf("sympathyBuffStrength").forGetter(v -> Float.valueOf(v.sympathyBuffStrength)), (App)Codec.INT.fieldOf("sympathyBuffedCycles").forGetter(v -> v.sympathyBuffedCycles)).apply((Applicative)obj, (attributes, modifierPositions, tunedAttribute, demandsFuel, chainProcessingBonus, sympathyDamageStacks, sympathyBuffStrength, sympathyBuffedCycles) -> new ArtificeAttributeData((List<ArtificeAttributeValue>)attributes, (List<BlockPos>)modifierPositions, tunedAttribute.orElse(null), (boolean)demandsFuel, chainProcessingBonus.floatValue(), (int)sympathyDamageStacks, sympathyBuffStrength.floatValue(), (int)sympathyBuffedCycles)));
    public final ArtificeAttributeValue focusingSpeed = new ArtificeAttributeValue(ArtificeAttributeType.FOCUSING_SPEED);
    public final ArtificeAttributeValue instability = new ArtificeAttributeValue(ArtificeAttributeType.INSTABILITY);
    public final ArtificeAttributeValue fuelUsageRate = new ArtificeAttributeValue(ArtificeAttributeType.FUEL_USAGE_RATE);
    public final ArtificeAttributeValue fortuneChance = new ArtificeAttributeValue(ArtificeAttributeType.FORTUNE_CHANCE);
    public final ArtificeAttributeValue chainFocusingChance = new ArtificeAttributeValue(ArtificeAttributeType.CHAIN_FOCUSING_CHANCE);
    public final ArtificeAttributeValue damageAbsorptionChance = new ArtificeAttributeValue(ArtificeAttributeType.DAMAGE_ABSORPTION_CHANCE);
    public final ArtificeAttributeValue restorationChance = new ArtificeAttributeValue(ArtificeAttributeType.RESTORATION_CHANCE);
    public final ArtificeAttributeValue weaknessTuning = new ArtificeAttributeValue(ArtificeAttributeType.WEAKNESS_TUNING);
    public final ArtificeAttributeValue tuningPotency = new ArtificeAttributeValue(ArtificeAttributeType.TUNING_POTENCY);
    public final ArtificeAttributeValue tuningStrain = new ArtificeAttributeValue(ArtificeAttributeType.TUNING_STRAIN);
    public final ArtificeAttributeValue causticSynergy = new ArtificeAttributeValue(ArtificeAttributeType.CAUSTIC_SYNERGY);
    public final ArtificeAttributeValue resonanceTuning = new ArtificeAttributeValue(ArtificeAttributeType.RESONANCE_TUNING);
    public final ArtificeAttributeValue misfortuneReversal = new ArtificeAttributeValue(ArtificeAttributeType.MISFORTUNE_REVERSAL);
    public final List<ArtificeAttributeValue> attributes = List.of(this.focusingSpeed, this.instability, this.fuelUsageRate, this.fortuneChance, this.chainFocusingChance, this.damageAbsorptionChance, this.restorationChance, this.weaknessTuning, this.tuningPotency, this.tuningStrain);
    public final List<BlockPos> modifierPositions = new ArrayList<BlockPos>();
    @Nullable
    private ArtificeInfluenceData influenceData;
    public ArtificeAttributeType tunedAttribute;
    public boolean demandsFuel;
    public float chainProcessingBonus;
    public int sympathyDamageStacks;
    public float sympathyBuffStrength;
    public int sympathyBuffedCycles;

    public ArtificeAttributeData(IArtificeAcceptor target) {
        if (target.getAttributes() != null) {
            this.tunedAttribute = target.getAttributes().tunedAttribute;
        }
        target.applyAugments(this::applyAugment);
    }

    public ArtificeAttributeData applyModifierInfluence(ArtificeInfluenceData influenceData) {
        this.influenceData = influenceData;
        if (influenceData != null) {
            for (ArtificeModifierSourceInstance modifier : influenceData.modifiers()) {
                modifier.modifyFocusing(this::applyModifier);
                modifier.applyAugments(this::applyAugment);
                this.modifierPositions.add(modifier.sourcePosition);
                if (!modifier.consumesFuel()) continue;
                this.demandsFuel = true;
            }
        }
        this.applyTuning();
        return this;
    }

    public ArtificeAttributeData(List<ArtificeAttributeValue> attributes, List<BlockPos> modifierPositions, ArtificeAttributeType tunedAttribute, boolean demandsFuel, float chainProcessingBonus, int sympathyDamageStacks, float sympathyBuffStrength, int sympathyBuffedCycles) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            this.attributes.get(i).copyFrom(attributes.get(i));
        }
        this.modifierPositions.addAll(modifierPositions);
        this.tunedAttribute = tunedAttribute;
        this.demandsFuel = demandsFuel;
        this.chainProcessingBonus = chainProcessingBonus;
        this.sympathyDamageStacks = sympathyDamageStacks;
        this.sympathyBuffStrength = sympathyBuffStrength;
        this.sympathyBuffedCycles = sympathyBuffedCycles;
    }

    public ArtificeAttributeData() {
    }

    public void applyTuning() {
        for (ArtificeAttributeValue attribute : this.attributes) {
            attribute.clearModifiers();
        }
        CausticCatalystItem.scalePotency(this);
        List<ArtificeAttributeType> attributesForTuning = this.getExistingAttributesForTuning();
        if (this.tunedAttribute != null) {
            float potency = this.tuningPotency.getValue(this);
            float strain = this.tuningStrain.getValue(this);
            for (ArtificeAttributeType attribute : attributesForTuning) {
                ArtificeAttributeValue value = attribute.getAttributeValue(this);
                boolean isBoosted = this.tunedAttribute.equals(attribute);
                AppliedTuningType tuningType = isBoosted ? AppliedTuningType.POSITIVE : AppliedTuningType.NEGATIVE;
                float bonus = tuningType.getMultiplier(attribute) * (isBoosted ? potency : strain);
                value.applyModifier(new TuningModifier(TuningModifier.TUNING_FORK, bonus));
            }
        }
        ImpurityStabilizer.applyWeaknessTuning(this, attributesForTuning);
        ResonanceTuner.exchangeSpeed(this);
    }

    public void applyAugment(ItemStack augment) {
        if (!augment.has(MalumDataComponents.ARTIFICE_AUGMENT)) {
            throw new IllegalArgumentException();
        }
        ArtificeAugmentDataComponent augmentData = (ArtificeAugmentDataComponent)augment.get(MalumDataComponents.ARTIFICE_AUGMENT);
        for (ArtificeModifier modifier : augmentData.modifiers()) {
            this.applyModifier(modifier);
        }
    }

    public void applyModifier(ArtificeModifier modifier) {
        this.getAttributeValue(modifier.attribute()).applyModifier(modifier);
    }

    public Optional<ArtificeInfluenceData> getInfluenceData(Level level) {
        if (this.influenceData == null) {
            this.influenceData = ArtificeInfluenceData.reconstructData(level, this);
        }
        return Optional.ofNullable(this.influenceData);
    }

    public void applyTuningForkBuff(ServerLevel level, BlockPos pos) {
        this.selectNextAttributeForTuning();
        this.applyTuning();
        float volume = RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)1.25f, (float)1.75f);
        float pitch = RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)0.75f, (float)1.25f);
        level.playSound(null, pos, (SoundEvent)MalumSoundEvents.TUNING_FORK_TINKER.get(), SoundSource.BLOCKS, volume, pitch);
        BlockStateHelper.updateAndNotifyState((Level)level, (BlockPos)pos);
    }

    public void selectNextAttributeForTuning() {
        if (this.tunedAttribute == null) {
            this.tunedAttribute = ArtificeAttributeType.CRUCIBLE_ATTRIBUTES.getFirst();
            return;
        }
        List<ArtificeAttributeType> attributes = this.getExistingAttributesForTuning();
        int index = attributes.indexOf(this.tunedAttribute) + 1;
        if (index >= attributes.size()) {
            this.tunedAttribute = null;
            return;
        }
        this.tunedAttribute = attributes.get(index);
    }

    public ArtificeAttributeValue getAttributeValue(ArtificeAttributeType attributeType) {
        return attributeType.getAttributeValue(this);
    }

    public List<ArtificeAttributeType> getExistingAttributesForTuning() {
        return ArtificeAttributeType.getExistingAttributes(this).stream().filter(ArtificeAttributeType::canBeTuned).toList();
    }

    public ArtificeAttributeValue figureOutWeakestAttribute(List<ArtificeAttributeType> tunedValues) {
        if (tunedValues.size() == 1) {
            return tunedValues.getFirst().getAttributeValue(this);
        }
        return tunedValues.stream().map(t -> t.getAttributeValue(this)).min((t1, t2) -> {
            float difference1 = t1.type.tuningBehavior.getRelativeValue(this, (ArtificeAttributeValue)t1);
            float difference2 = t2.type.tuningBehavior.getRelativeValue(this, (ArtificeAttributeValue)t2);
            return Float.compare(difference1, difference2);
        }).orElse(null);
    }
}

