/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.datagen.recipe.builder.SpiritFocusingRecipeBuilder;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import team.lodestar.lodestone.registry.common.tag.LodestoneItemTags;

public class MalumSpiritFocusingRecipes
implements IConditionBuilder {
    protected static void buildRecipes(RecipeOutput recipeOutput) {
        int complexDuration = 2700;
        int metalDuration = 900;
        int shortDuration = 300;
        new SpiritFocusingRecipeBuilder(shortDuration, 1, (Holder<Item>)MalumItems.ALCHEMICAL_IMPETUS, (ItemLike)Items.GUNPOWDER, 8).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 1).save(recipeOutput);
        new SpiritFocusingRecipeBuilder(shortDuration, 1, (Holder<Item>)MalumItems.ALCHEMICAL_IMPETUS, (ItemLike)Items.GLOWSTONE_DUST, 8).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 1).save(recipeOutput);
        new SpiritFocusingRecipeBuilder(shortDuration, 1, (Holder<Item>)MalumItems.ALCHEMICAL_IMPETUS, (ItemLike)Items.REDSTONE, 8).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 1).save(recipeOutput);
        new SpiritFocusingRecipeBuilder(shortDuration, 1, (Holder<Item>)MalumItems.ALCHEMICAL_IMPETUS, (ItemLike)Items.QUARTZ, 4).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 2).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 2).save(recipeOutput);
        new SpiritFocusingRecipeBuilder(shortDuration, 1, (Holder<Item>)MalumItems.ALCHEMICAL_IMPETUS, (ItemLike)MalumItems.BLAZING_QUARTZ.get(), 4).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 2).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 2).save(recipeOutput);
        new SpiritFocusingRecipeBuilder(shortDuration, 1, (Holder<Item>)MalumItems.ALCHEMICAL_IMPETUS, (ItemLike)Items.PRISMARINE_SHARD, 4).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 2).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 2).save(recipeOutput);
        new SpiritFocusingRecipeBuilder(shortDuration, 1, (Holder<Item>)MalumItems.ALCHEMICAL_IMPETUS, (ItemLike)Items.AMETHYST_SHARD, 4).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 2).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 2).save(recipeOutput);
        new SpiritFocusingRecipeBuilder(complexDuration, 1, (Holder<Item>)MalumItems.ZEPHYR_IMPETUS, (ItemLike)Items.WIND_CHARGE, 4).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 2).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 2).addSpirit(MalumSpiritTypes.SACRED_SPIRIT, 2).save(recipeOutput);
        new SpiritFocusingRecipeBuilder(complexDuration, 1, (Holder<Item>)MalumItems.ZEPHYR_IMPETUS, (ItemLike)MalumItems.WIND_NUCLEUS.get(), 4).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 2).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 2).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 2).save(recipeOutput);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.IRON_IMPETUS, MalumItems.IRON_NODE);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.GOLD_IMPETUS, MalumItems.GOLD_NODE);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.COPPER_IMPETUS, MalumItems.COPPER_NODE);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.LEAD_IMPETUS, MalumItems.LEAD_NODE, (TagKey<Item>)LodestoneItemTags.NUGGETS_LEAD);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.SILVER_IMPETUS, MalumItems.SILVER_NODE, (TagKey<Item>)LodestoneItemTags.NUGGETS_SILVER);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.ALUMINUM_IMPETUS, MalumItems.ALUMINUM_NODE, (TagKey<Item>)LodestoneItemTags.NUGGETS_ALUMINUM);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.NICKEL_IMPETUS, MalumItems.NICKEL_NODE, (TagKey<Item>)LodestoneItemTags.NUGGETS_NICKEL);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.URANIUM_IMPETUS, MalumItems.URANIUM_NODE, (TagKey<Item>)LodestoneItemTags.NUGGETS_URANIUM);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.COBALT_IMPETUS, MalumItems.COBALT_NODE, (TagKey<Item>)LodestoneItemTags.NUGGETS_COBALT);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.OSMIUM_IMPETUS, MalumItems.OSMIUM_NODE, (TagKey<Item>)LodestoneItemTags.NUGGETS_OSMIUM);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.ZINC_IMPETUS, MalumItems.ZINC_NODE, (TagKey<Item>)LodestoneItemTags.NUGGETS_ZINC);
        MalumSpiritFocusingRecipes.addImpetusRecipes(recipeOutput, metalDuration, MalumItems.TIN_IMPETUS, MalumItems.TIN_NODE, (TagKey<Item>)LodestoneItemTags.NUGGETS_TIN);
    }

    public static void addImpetusRecipes(RecipeOutput recipeOutput, int duration, Holder<Item> impetus, Holder<Item> node) {
        ResourceLocation recipeName = MalumMod.malumPath("node_focusing_" + BuiltInRegistries.ITEM.getKey((Object)((Item)node.value())).getPath().replace("_node", ""));
        new SpiritFocusingRecipeBuilder(duration, 2, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)impetus.value()}), (ItemLike)node.value(), 3).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 2).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 2).save(recipeOutput, recipeName);
    }

    public static void addImpetusRecipes(RecipeOutput recipeOutput, int duration, Holder<Item> impetus, Holder<Item> node, TagKey<Item> nugget) {
        ResourceLocation recipeName = MalumMod.malumPath("node_focusing_" + nugget.location().getPath().replace("nuggets/", ""));
        new SpiritFocusingRecipeBuilder(duration, 2, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)impetus.value()}), (ItemLike)node.value(), 3).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 2).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 2).save(recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(nugget.location()))}), recipeName);
    }
}

