/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.worldgen;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.registry.common.worldgen.MalumFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class PlacedFeatureDatagen {
    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter features = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(MalumFeatures.PlacedFeatures.ORE_SOULSTONE, (Object)PlacedFeatureDatagen.addOreFeature(features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_SOULSTONE_ORE), -64, 100, 3, new PlacementModifier[0]));
        context.register(MalumFeatures.PlacedFeatures.ORE_BRILLIANT, (Object)PlacedFeatureDatagen.addOreFeature(features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_BRILLIANT_ORE), -64, 40, 3, new PlacementModifier[0]));
        context.register(MalumFeatures.PlacedFeatures.ORE_NATURAL_QUARTZ, (Object)PlacedFeatureDatagen.addOreFeature(features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_NATURAL_QUARTZ_ORE), -64, 10, 1, new PlacementModifier[0]));
        context.register(MalumFeatures.PlacedFeatures.ORE_BLAZING_QUARTZ, (Object)PlacedFeatureDatagen.addOreFeature(features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_BLAZING_QUARTZ_ORE), -16, 112, 3, new PlacementModifier[0]));
        context.register(MalumFeatures.PlacedFeatures.ORE_CTHONIC_GOLD, (Object)PlacedFeatureDatagen.addOreFeature(features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_CTHONIC_GOLD_ORE_FEATURE), -48, 0, 1, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)4)}));
        context.register(MalumFeatures.PlacedFeatures.RUNEWOOD_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_RUNEWOOD_TREE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)48), CountPlacement.of((IntProvider)UniformInt.of((int)1, (int)3)), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP}).build()));
        context.register(MalumFeatures.PlacedFeatures.RARE_RUNEWOOD_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_RUNEWOOD_TREE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)64), CountPlacement.of((IntProvider)UniformInt.of((int)1, (int)2)), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP}).build()));
        context.register(MalumFeatures.PlacedFeatures.AZURE_RUNEWOOD_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_AZURE_RUNEWOOD_TREE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)64), CountPlacement.of((IntProvider)UniformInt.of((int)1, (int)3)), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP}).build()));
        context.register(MalumFeatures.PlacedFeatures.RARE_AZURE_RUNEWOOD_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_AZURE_RUNEWOOD_TREE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)80), CountPlacement.of((IntProvider)UniformInt.of((int)1, (int)2)), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP}).build()));
        context.register(MalumFeatures.PlacedFeatures.QUARTZ_GEODE_FEATURE, (Object)new PlacedFeature((Holder)features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_QUARTZ_GEODE_FEATURE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)24), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)6), (VerticalAnchor)VerticalAnchor.absolute((int)-10)), BiomeFilter.biome()}).build()));
        context.register(MalumFeatures.PlacedFeatures.DEEPSLATE_QUARTZ_GEODE_FEATURE, (Object)new PlacedFeature((Holder)features.getOrThrow(MalumFeatures.ConfiguredFeatures.CONFIGURED_DEEPSLATE_QUARTZ_GEODE_FEATURE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)24), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)6), (VerticalAnchor)VerticalAnchor.absolute((int)-10)), BiomeFilter.biome()}).build()));
    }

    private static PlacedFeature addOreFeature(Holder<ConfiguredFeature<?, ?>> configureFeature, int minHeight, int maxHeight, int count, PlacementModifier ... extraModifiers) {
        ImmutableList modifiers = ImmutableList.builder().add((Object[])new PlacementModifier[]{CountPlacement.of((int)count), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)minHeight), (VerticalAnchor)VerticalAnchor.absolute((int)maxHeight)), InSquarePlacement.spread(), BiomeFilter.biome()}).add((Object[])extraModifiers).build();
        return new PlacedFeature(configureFeature, (List)modifiers);
    }
}

