/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.spirit_mote;

import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class SpiritMotePlaceParticleEffect
extends MalumNetworkedParticleEffectType<NetworkedParticleEffectExtraData> {
    public SpiritMotePlaceParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, NetworkedParticleEffectExtraData extraData) {
        BlockPos position = positionData.getAsBlockPos();
        Vec3 center = position.getCenter();
        for (int i = 0; i < 4; ++i) {
            int xOffset = Mth.clamp((int)(i % 3), (int)0, (int)1);
            int zOffset = Mth.clamp((int)((i - 1) % 4), (int)0, (int)1);
            float xMotion = (float)(i % 2) * (i > 1 ? 0.06f : -0.06f);
            float zMotion = (float)((i + 1) % 2) * (i > 1 ? -0.06f : 0.06f);
            SpiritArcanaType spirit = colorData.getSpirit();
            for (int j = 0; j < 20; ++j) {
                int delay = j * 2;
                int upwards = j % 2;
                Vec3 offsetPosition = new Vec3((double)(position.getX() + xOffset), (double)(position.getY() + upwards), (double)(position.getZ() + zOffset));
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spirit);
                lightSpecs.getBuilder().setLifeDelay(delay).multiplyLifetime(2.5f).setMotion((double)xMotion, 0.0, (double)zMotion).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.4f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().setLifeDelay(delay).multiplyLifetime(1.5f).setMotion((double)xMotion, 0.0, (double)zMotion).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.nextFloat((RandomSource)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build();
        WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.GIANT_GLOWING_STAR.get())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.9f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setLifetime(25).setSpinData((SpinParticleDataWrapper)spinData).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)4.0f, (float)0.5f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN).build()).setColorData((ColorParticleDataWrapper)colorData.getColor()).setRandomOffset((double)0.2f).enableNoClip().repeat(level, center, 3);
    }
}

