/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.staff;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.SparkParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class UnwindingChaosChargeParticleEffect
extends MalumNetworkedParticleEffectType<UnwindingChaosChargeEffectData> {
    public UnwindingChaosChargeParticleEffect(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectExtraData>> getExtraCodec() {
        return Optional.of(UnwindingChaosChargeEffectData.STREAM_CODEC);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, UnwindingChaosChargeEffectData extraData) {
        Entity entity = level.getEntity(extraData.entityId);
        if (entity != null) {
            Color smokeColor = new Color(45, 15, 15);
            long gameTime = level.getGameTime();
            Vec3 pos = positionData.getAsVector();
            Vec3 direction = pos.subtract(entity.position()).normalize();
            float yRot = (float)(Mth.atan2((double)direction.x, (double)direction.z) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.cross(direction);
            Consumer<LodestoneWorldParticle> behavior = p -> {
                Vec3 distance = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0).subtract(p.getParticlePosition());
                if (distance.length() == 0.0) {
                    distance = new Vec3(0.0, (double)0.02f, 0.0);
                }
                float delta = Math.max((float)p.getAge() / (float)p.getLifetime(), 0.0f);
                float lerp = Easing.QUINTIC_IN_OUT.ease(delta, 0.05f, 0.5f);
                float velocity = Easing.CIRC_IN.ease((double)delta, (double)0.05f, (double)0.2f + distance.length() * (double)1.2f);
                Vec3 speed = p.getParticleSpeed().lerp(distance.normalize().scale((double)velocity), (double)lerp);
                p.setParticleSpeed(speed);
            };
            for (int i = 0; i < 16; ++i) {
                SpiritArcanaType cyclingSpiritType = colorData.getSpirit();
                float spread = RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)0.6f);
                float speed = RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)0.8f);
                float angle = (float)i / 16.0f * (float)Math.PI * 2.0f;
                Vec3 particleDirection = direction.add(left.scale(Math.sin(angle) * (double)spread)).add(up.scale(Math.cos(angle) * (double)spread)).normalize().scale((double)speed);
                Vec3 particlePosition = pos.add(particleDirection.scale(2.0));
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, cyclingSpiritType, new WorldParticleOptions((ParticleType)MalumParticles.SPARK.get()));
                GenericParticleData transparencyData = GenericParticleData.create((float)0.4f, (float)0.8f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.EXPO_IN_OUT).build();
                int lifeDelay = i * 2;
                int lifetime = 20;
                lightSpecs.getBuilder().setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior()).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)2.0f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_IN_OUT).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)2.0f, (float)2.5f))).modifyColorData(c -> c.multiplyCoefficient(0.5f)).setTransparencyData((GenericParticleDataWrapper)transparencyData).setLifeDelay(lifeDelay).setLifetime(lifetime).addTickActor(behavior);
                lightSpecs.getBloomBuilder().setTransparencyData((GenericParticleDataWrapper)transparencyData).setLifeDelay(lifeDelay).setLifetime(lifetime).addTickActor(behavior).modifyColorData(c -> c.multiplyCoefficient(0.5f)).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.7f, (float)1.1f))).modifyTransparencyData(d -> d.multiplyCoefficient(1.4f));
                lightSpecs.spawnParticles();
                lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, cyclingSpiritType, new WorldParticleOptions((ParticleType)LodestoneParticleTypes.WISP_PARTICLE.get()));
                transparencyData = GenericParticleData.create((float)1.0f, (float)0.0f).setCoefficient(1.5f).build();
                lightSpecs.getBuilder().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)smokeColor).build()).setTransparencyData((GenericParticleDataWrapper)transparencyData).setLifeDelay(lifeDelay).addTickActor(behavior).setLifetime(lifetime);
                lightSpecs.spawnParticlesRaw();
            }
        }
    }

    public record UnwindingChaosChargeEffectData(int entityId) implements NetworkedParticleEffectExtraData
    {
        public static final Codec<UnwindingChaosChargeEffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("entityId").forGetter(UnwindingChaosChargeEffectData::entityId)).apply((Applicative)instance, UnwindingChaosChargeEffectData::new));
        public static final StreamCodec<ByteBuf, UnwindingChaosChargeEffectData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    }
}

