/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.components;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.components.IComponentProcessorHelper;
import moze_intel.projecte.emc.components.DataComponentManager;
import moze_intel.projecte.utils.Constants;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class ComponentProcessorHelper
implements IComponentProcessorHelper {
    private static final Function<Holder<Item>, ItemInfo> HOLDER_TO_INFO = ItemInfo::fromItem;
    private static final Function<ItemStack, @Nullable ItemInfo> STACK_TO_INFO = stack -> stack.isEmpty() ? null : ItemInfo.fromStack(stack);
    @Nullable
    private Object2LongMap<DyeColor> colorEmc;

    public static ComponentProcessorHelper instance() {
        return (ComponentProcessorHelper)IComponentProcessorHelper.INSTANCE;
    }

    void updateCachedValues(@Nullable ToLongFunction<ItemInfo> emcLookup) {
        if (emcLookup == null) {
            this.colorEmc = null;
        } else {
            this.colorEmc = new Object2LongOpenHashMap();
            for (DyeColor color : Constants.COLORS) {
                long minColorEmc = this.getMinValue(emcLookup, BuiltInRegistries.ITEM.getTagOrEmpty(color.getTag()), HOLDER_TO_INFO);
                if (minColorEmc <= 0L) continue;
                this.colorEmc.put((Object)color, minColorEmc);
            }
        }
    }

    @Override
    @NotNull
    public ItemInfo getPersistentInfo(@NotNull ItemInfo info) {
        return DataComponentManager.getPersistentInfo(info);
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getColorEmc(@NotNull DyeColor color) {
        return this.colorEmc == null ? 0L : this.colorEmc.getLong((Object)color);
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getMinEmcFor(@NotNull ToLongFunction<ItemInfo> emcLookup, @NotNull Ingredient ingredient) {
        return this.getMinValue(emcLookup, Arrays.asList(this.getMatchingStacks(ingredient)), STACK_TO_INFO);
    }

    private ItemStack[] getMatchingStacks(Ingredient ingredient) {
        try {
            return ingredient.getItems();
        }
        catch (Exception e) {
            ICustomIngredient customIngredient = ingredient.getCustomIngredient();
            if (customIngredient != null) {
                ResourceLocation name = NeoForgeRegistries.INGREDIENT_TYPES.getKey((Object)customIngredient.getType());
                if (name == null) {
                    PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Ingredient of type: {} crashed when getting the matching stacks. Please report this to the ingredient's creator.", (Object)customIngredient.getClass(), (Object)e);
                } else {
                    PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Ingredient of type: {} crashed when getting the matching stacks. Please report this to the ingredient's creator ({}).", new Object[]{name, name.getNamespace(), e});
                }
            } else {
                PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Crashed when getting the matching stacks.", (Throwable)e);
            }
            return new ItemStack[0];
        }
    }

    private <TYPE> @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getMinValue(@NotNull ToLongFunction<ItemInfo> emcLookup, @NotNull Iterable<TYPE> iterable, @NotNull Function<TYPE, @Nullable ItemInfo> infoCreator) {
        long minEmc = 0L;
        for (TYPE type : iterable) {
            long enc;
            ItemInfo info = infoCreator.apply(type);
            if (info == null || (enc = emcLookup.applyAsLong(info)) == 0L || minEmc != 0L && enc >= minEmc) continue;
            minEmc = enc;
        }
        return minEmc;
    }
}

