/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.components.processor;

import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.components.DataComponentProcessor;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.config.PEConfigTranslations;
import moze_intel.projecte.emc.components.processor.PersistentComponentProcessor;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@DataComponentProcessor
public class ArmorTrimProcessor
extends PersistentComponentProcessor<ArmorTrim> {
    @Override
    public String getName() {
        return PEConfigTranslations.DCP_ARMOR_TRIM.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.DCP_ARMOR_TRIM.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.DCP_ARMOR_TRIM.tooltip();
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long recalculateEMC(@NotNull ItemInfo info, @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long currentEMC, @NotNull ArmorTrim trim) throws ArithmeticException {
        Holder material = ((TrimMaterial)trim.material().value()).ingredient();
        long materialEmc = IEMCProxy.INSTANCE.getValue((Holder<Item>)material);
        if (materialEmc == 0L) {
            return 0L;
        }
        Holder template = ((TrimPattern)trim.pattern().value()).templateItem();
        long templateEmc = IEMCProxy.INSTANCE.getValue((Holder<Item>)template);
        if (templateEmc == 0L) {
            return 0L;
        }
        return Math.addExact(Math.addExact(currentEMC, materialEmc), templateEmc);
    }

    @Override
    protected boolean validItem(@NotNull ItemInfo info) {
        return info.getItem().is(ItemTags.TRIMMABLE_ARMOR);
    }

    @Override
    protected boolean shouldPersist(@NotNull ItemInfo info, @NotNull ArmorTrim component) {
        return true;
    }

    @Override
    protected DataComponentType<ArmorTrim> getComponentType(@NotNull ItemInfo info) {
        return DataComponents.TRIM;
    }
}

