/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.customConversions;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMaps;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.conversion.ConversionGroup;
import moze_intel.projecte.api.conversion.CustomConversion;
import moze_intel.projecte.api.conversion.CustomConversionFile;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.PEConfigTranslations;
import moze_intel.projecte.impl.codec.PECodecHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.util.TriConsumer;

@EMCMapper
public class CustomConversionMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final FileToIdConverter CONVERSION_LISTER = FileToIdConverter.json((String)"pe_custom_conversions");
    private static final TriConsumer<IMappingCollector<NormalizedSimpleStack, Long>, NormalizedSimpleStack, CustomConversion> CONVERSION_CONSUMER = (collector, nss, conversion) -> collector.setValueFromConversion(conversion.count(), nss, conversion.ingredients());

    @Override
    public String getName() {
        return PEConfigTranslations.MAPPING_CUSTOM_CONVERSION_MAPPER.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.MAPPING_CUSTOM_CONVERSION_MAPPER.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.MAPPING_CUSTOM_CONVERSION_MAPPER.tooltip();
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        Map<ResourceLocation, CustomConversionFile> files = CustomConversionMapper.load(registryAccess, resourceManager);
        for (CustomConversionFile file : files.values()) {
            CustomConversionMapper.addMappingsFromFile(file, mapper);
        }
    }

    private static Map<ResourceLocation, CustomConversionFile> load(RegistryAccess registryAccess, ResourceManager resourceManager) {
        HashMap<ResourceLocation, CustomConversionFile> loading = new HashMap<ResourceLocation, CustomConversionFile>();
        RegistryOps serializationContext = registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        for (Map.Entry entry : CONVERSION_LISTER.listMatchingResourceStacks(resourceManager).entrySet()) {
            ResourceLocation file = (ResourceLocation)entry.getKey();
            ResourceLocation conversionId = CONVERSION_LISTER.fileToId(file);
            PECore.debugLog("Considering file {}, ID {}", file, conversionId);
            NSSFake.setCurrentNamespace(conversionId.toString());
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        Optional<CustomConversionFile> fileOptional = PECodecHelper.read((DynamicOps<JsonElement>)serializationContext, (Reader)reader, CustomConversionFile.CODEC, "custom conversion file");
                        if (!fileOptional.isPresent()) continue;
                        loading.merge(conversionId, fileOptional.get(), CustomConversionFile::merge);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (IOException e) {
                    PECore.LOGGER.error("Could not load resource {}", (Object)file, (Object)e);
                }
            }
        }
        NSSFake.resetNamespace();
        return loading;
    }

    private static void addMappingsFromFile(CustomConversionFile file, IMappingCollector<NormalizedSimpleStack, Long> mapper) {
        for (Map.Entry entry : file.groups().entrySet()) {
            ConversionGroup group = (ConversionGroup)entry.getValue();
            PECore.debugLog("Adding conversions from group '{}' with comment '{}'", entry.getKey(), group.comment());
            for (CustomConversion conversion : group.conversions()) {
                mapper.addConversion(conversion.count(), conversion.output(), (Object2IntMap<NormalizedSimpleStack>)conversion.ingredients());
            }
        }
        ObjectBidirectionalIterator iterator = Object2LongSortedMaps.fastIterator(file.values().setValueBefore());
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            ((NormalizedSimpleStack)entry.getKey()).forSelfAndEachElement(mapper, entry.getLongValue(), IMappingCollector::setValueBefore);
        }
        iterator = Object2LongSortedMaps.fastIterator(file.values().setValueAfter());
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            ((NormalizedSimpleStack)entry.getKey()).forSelfAndEachElement(mapper, entry.getLongValue(), IMappingCollector::setValueAfter);
        }
        for (CustomConversion customConversion : file.values().conversions()) {
            if (customConversion.propagateTags()) {
                customConversion.output().forSelfAndEachElement(mapper, customConversion, CONVERSION_CONSUMER);
                continue;
            }
            CONVERSION_CONSUMER.accept(mapper, (Object)customConversion.output(), (Object)customConversion);
        }
    }
}

