/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.block_entities;

import moze_intel.projecte.api.block_entity.IRelay;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.EnumCollectorTier;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.WrappedItemHandler;
import moze_intel.projecte.gameObjs.container.CollectorMK1Container;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class CollectorMK1BlockEntity
extends EmcBlockEntity
implements MenuProvider {
    public static final ICapabilityProvider<CollectorMK1BlockEntity, @Nullable Direction, IItemHandler> INVENTORY_PROVIDER = (collector, side) -> {
        if (side == null) {
            return collector.joined;
        }
        if (side.getAxis().isVertical()) {
            return collector.automationAuxSlots;
        }
        return collector.automationInput;
    };
    private final ItemStackHandler input = new EmcBlockEntity.StackHandler(this.getInvSize()){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CollectorMK1BlockEntity.this.needsCompacting = true;
        }
    };
    private final EmcBlockEntity.StackHandler auxSlots = new EmcBlockEntity.StackHandler(3){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                CollectorMK1BlockEntity.this.needsCompacting = true;
            }
        }
    };
    private final CombinedInvWrapper toSort = new CombinedInvWrapper(new IItemHandlerModifiable[]{new RangedWrapper((IItemHandlerModifiable)this.auxSlots, 0, 1), this.input});
    public static final int UPGRADING_SLOT = 0;
    public static final int UPGRADE_SLOT = 1;
    public static final int LOCK_SLOT = 2;
    private final IItemHandlerModifiable automationAuxSlots;
    private final IItemHandlerModifiable automationInput;
    private final IItemHandler joined;
    private final long emcGen;
    private double unprocessedEMC;
    private boolean hasChargeableItem;
    private boolean hasFuel;
    private boolean needsCompacting = true;

    public CollectorMK1BlockEntity(BlockPos pos, BlockState state) {
        this(PEBlockEntityTypes.COLLECTOR, pos, state, EnumCollectorTier.MK1);
    }

    public CollectorMK1BlockEntity(BlockEntityTypeRegistryObject<? extends CollectorMK1BlockEntity> type, BlockPos pos, BlockState state, EnumCollectorTier tier) {
        super(type, pos, state, tier.getStorage());
        this.emcGen = tier.getGenRate();
        this.automationInput = new WrappedItemHandler(this, (IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN){

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return SlotPredicates.COLLECTOR_INV.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
        this.automationAuxSlots = new WrappedItemHandler(this, (IItemHandlerModifiable)this.auxSlots, WrappedItemHandler.WriteMode.OUT){

            @Override
            @NotNull
            public ItemStack extractItem(int slot, int count, boolean simulate) {
                return slot == 1 ? super.extractItem(slot, count, simulate) : ItemStack.EMPTY;
            }
        };
        this.joined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.automationInput, this.automationAuxSlots});
    }

    @Override
    protected boolean canAcceptEmc() {
        return this.hasFuel || this.hasChargeableItem;
    }

    public IItemHandler getInput() {
        return this.input;
    }

    public IItemHandler getAux() {
        return this.auxSlots;
    }

    protected int getInvSize() {
        return 8;
    }

    private ItemStack getUpgraded() {
        return this.auxSlots.getStackInSlot(1);
    }

    private ItemStack getLock() {
        return this.auxSlots.getStackInSlot(2);
    }

    private ItemStack getUpgrading() {
        return this.auxSlots.getStackInSlot(0);
    }

    public void clearLocked() {
        this.auxSlots.setStackInSlot(2, ItemStack.EMPTY);
    }

    @Override
    protected boolean emcAffectsComparators() {
        return true;
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, CollectorMK1BlockEntity collector) {
        if (collector.needsCompacting) {
            ItemHelper.compactInventory((IItemHandlerModifiable)collector.toSort);
            collector.needsCompacting = false;
        }
        collector.checkFuelOrKlein();
        collector.updateEmc(level, pos);
        collector.rotateUpgraded();
        collector.updateComparators(level, pos);
    }

    private void rotateUpgraded() {
        ItemStack lock;
        ItemStack upgraded = this.getUpgraded();
        if (!upgraded.isEmpty() && ((lock = this.getLock()).isEmpty() || upgraded.getItem() != lock.getItem() || upgraded.getCount() >= upgraded.getMaxStackSize())) {
            this.auxSlots.setStackInSlot(1, ItemHandlerHelper.insertItemStacked((IItemHandler)this.input, (ItemStack)upgraded.copy(), (boolean)false));
        }
    }

    private void checkFuelOrKlein() {
        ItemStack upgrading = this.getUpgrading();
        if (!upgrading.isEmpty()) {
            IItemEmcHolder emcHolder = (IItemEmcHolder)upgrading.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
            if (emcHolder != null) {
                if (emcHolder.getNeededEmc(upgrading) > 0L) {
                    this.hasChargeableItem = true;
                    this.hasFuel = false;
                } else {
                    this.hasChargeableItem = false;
                }
            } else {
                this.hasFuel = FuelMapper.isStackFuel(upgrading);
                this.hasChargeableItem = false;
            }
        } else {
            this.hasFuel = false;
            this.hasChargeableItem = false;
        }
    }

    private void updateEmc(@NotNull Level level, @NotNull BlockPos pos) {
        if (!this.hasMaxedEmc()) {
            this.unprocessedEMC += (double)((float)this.emcGen * ((float)CollectorMK1BlockEntity.getSunLevel(level, pos) / 320.0f));
            if (this.unprocessedEMC >= 1.0) {
                this.unprocessedEMC -= (double)this.forceInsertEmc((long)this.unprocessedEMC, IEmcStorage.EmcAction.EXECUTE);
            }
            this.markDirty(level, pos, false);
        }
        if (this.getStoredEmc() > 0L) {
            ItemStack fuelUpgrade;
            ItemStack upgrading = this.getUpgrading();
            if (this.hasChargeableItem) {
                IItemEmcHolder emcHolder = (IItemEmcHolder)upgrading.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
                if (emcHolder != null) {
                    long actualInserted = emcHolder.insertEmc(upgrading, Math.min(this.getStoredEmc(), this.emcGen), IEmcStorage.EmcAction.EXECUTE);
                    this.forceExtractEmc(actualInserted, IEmcStorage.EmcAction.EXECUTE);
                }
                return;
            }
            if (this.hasFuel && !(fuelUpgrade = FuelMapper.getFuelUpgrade(upgrading)).isEmpty()) {
                ItemStack lock = this.getLock();
                ItemStack result = lock.isEmpty() ? fuelUpgrade : lock.copy();
                long upgradeCost = IEMCProxy.INSTANCE.getValue(result) - IEMCProxy.INSTANCE.getValue(upgrading);
                if (upgradeCost >= 0L && this.getStoredEmc() >= upgradeCost) {
                    ItemStack upgrade = this.getUpgraded();
                    if (upgrade.isEmpty()) {
                        this.forceExtractEmc(upgradeCost, IEmcStorage.EmcAction.EXECUTE);
                        this.auxSlots.setStackInSlot(1, result);
                        upgrading.shrink(1);
                    } else if (result.is(upgrade.getItem()) && upgrade.getCount() < upgrade.getMaxStackSize()) {
                        this.forceExtractEmc(upgradeCost, IEmcStorage.EmcAction.EXECUTE);
                        upgrade.grow(1);
                        upgrading.shrink(1);
                        this.auxSlots.onContentsChanged(1);
                    }
                }
                return;
            }
            long toSend = this.getStoredEmc() < this.emcGen ? this.getStoredEmc() : this.emcGen;
            this.sendToAllAcceptors(level, pos, toSend);
            CollectorMK1BlockEntity.sendRelayBonus(level, pos);
        }
    }

    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcToNextGoal() {
        ItemStack lock = this.getLock();
        ItemStack upgrading = this.getUpgrading();
        long targetEmc = lock.isEmpty() ? IEMCProxy.INSTANCE.getValue(FuelMapper.getFuelUpgrade(upgrading)) : IEMCProxy.INSTANCE.getValue(lock);
        return Math.max(targetEmc - IEMCProxy.INSTANCE.getValue(upgrading), 0L);
    }

    public long getItemCharge() {
        ItemStack upgrading = this.getUpgrading();
        IItemEmcHolder emcHolder = (IItemEmcHolder)upgrading.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
        if (emcHolder != null) {
            return emcHolder.getStoredEmc(upgrading);
        }
        return -1L;
    }

    public double getItemChargeProportion() {
        long charge = this.getItemCharge();
        if (charge <= 0L) {
            return -1.0;
        }
        ItemStack upgrading = this.getUpgrading();
        IItemEmcHolder emcHolder = (IItemEmcHolder)upgrading.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
        if (emcHolder == null) {
            return -1.0;
        }
        long max = emcHolder.getMaximumEmc(upgrading);
        if (charge >= max) {
            return 1.0;
        }
        return (double)charge / (double)max;
    }

    public int getSunLevel() {
        return this.level == null ? 0 : CollectorMK1BlockEntity.getSunLevel(this.level, this.worldPosition);
    }

    public static int getSunLevel(@NotNull Level level, @NotNull BlockPos pos) {
        if (level.dimensionType().ultraWarm()) {
            return 16;
        }
        return level.getMaxLocalRawBrightness(pos.above()) + 1;
    }

    public double getFuelProgress() {
        long reqEmc;
        ItemStack upgrading = this.getUpgrading();
        if (!FuelMapper.isStackFuel(upgrading)) {
            return 0.0;
        }
        ItemStack lock = this.getLock();
        if (!lock.isEmpty()) {
            reqEmc = IEMCProxy.INSTANCE.getValue(lock) - IEMCProxy.INSTANCE.getValue(upgrading);
            if (reqEmc < 0L) {
                return 0.0;
            }
        } else {
            ItemStack fuelUpgrade = FuelMapper.getFuelUpgrade(upgrading);
            if (fuelUpgrade.isEmpty()) {
                return 0.0;
            }
            reqEmc = IEMCProxy.INSTANCE.getValue(fuelUpgrade) - IEMCProxy.INSTANCE.getValue(upgrading);
        }
        if (this.getStoredEmc() >= reqEmc) {
            return 1.0;
        }
        return (double)this.getStoredEmc() / (double)reqEmc;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.unprocessedEMC = tag.getDouble("unprocessed_emc");
        this.input.deserializeNBT(registries, tag.getCompound("input"));
        this.auxSlots.deserializeNBT(registries, tag.getCompound("aux_slots"));
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putDouble("unprocessed_emc", this.unprocessedEMC);
        tag.put("input", (Tag)this.input.serializeNBT(registries));
        tag.put("aux_slots", (Tag)this.auxSlots.serializeNBT(registries));
    }

    private static void sendRelayBonus(@NotNull Level level, @NotNull BlockPos pos) {
        for (Direction dir : Constants.DIRECTIONS) {
            BlockPos relayPos = pos.relative(dir);
            BlockEntity blockEntity = WorldHelper.getBlockEntity((BlockGetter)level, relayPos);
            if (!(blockEntity instanceof IRelay)) continue;
            IRelay relay = (IRelay)blockEntity;
            relay.addBonus(level, relayPos);
        }
    }

    @NotNull
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerIn) {
        return new CollectorMK1Container(windowId, playerInventory, this);
    }

    @NotNull
    public Component getDisplayName() {
        return TextComponentUtil.build(PEBlocks.COLLECTOR);
    }
}

