/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.block_entities;

import moze_intel.projecte.api.block_entity.IRelay;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.gameObjs.EnumRelayTier;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.WrappedItemHandler;
import moze_intel.projecte.gameObjs.container.RelayMK1Container;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelayMK1BlockEntity
extends EmcBlockEntity
implements MenuProvider,
IRelay {
    public static final ICapabilityProvider<RelayMK1BlockEntity, @Nullable Direction, IItemHandler> INVENTORY_PROVIDER = (relay, side) -> {
        if (side == null) {
            return relay.joined;
        }
        if (side.getAxis().isVertical()) {
            return relay.automationOutput;
        }
        return relay.automationInput;
    };
    private final EmcBlockEntity.CompactableStackHandler input;
    private final ItemStackHandler output = new EmcBlockEntity.StackHandler(1);
    private final IItemHandlerModifiable automationOutput;
    private final IItemHandlerModifiable automationInput;
    private final IItemHandler joined;
    private final long chargeRate;
    private double bonusEMC;

    public RelayMK1BlockEntity(BlockPos pos, BlockState state) {
        this(PEBlockEntityTypes.RELAY, pos, state, 7, EnumRelayTier.MK1);
    }

    RelayMK1BlockEntity(BlockEntityTypeRegistryObject<? extends RelayMK1BlockEntity> type, BlockPos pos, BlockState state, int sizeInv, EnumRelayTier tier) {
        super(type, pos, state, tier.getStorage());
        this.chargeRate = tier.getChargeRate();
        this.input = new EmcBlockEntity.CompactableStackHandler(this, sizeInv){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return SlotPredicates.RELAY_INV.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.automationOutput = new WrappedItemHandler(this, (IItemHandlerModifiable)this.output, WrappedItemHandler.WriteMode.IN_OUT){

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return SlotPredicates.EMC_HOLDER.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            @Override
            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stack = this.getStackInSlot(slot);
                IItemEmcHolder emcHolder = (IItemEmcHolder)stack.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
                if (emcHolder != null && emcHolder.getNeededEmc(stack) > 0L) {
                    return ItemStack.EMPTY;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
        this.joined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.automationInput, this.automationOutput});
    }

    @Override
    public boolean isRelay() {
        return true;
    }

    private ItemStack getCharging() {
        return this.output.getStackInSlot(0);
    }

    private ItemStack getBurn() {
        return this.input.getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.input;
    }

    public IItemHandler getOutput() {
        return this.output;
    }

    @Override
    protected boolean emcAffectsComparators() {
        return true;
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, RelayMK1BlockEntity relay) {
        ItemStack chargeable;
        IItemEmcHolder emcHolder;
        relay.sendToAllAcceptors(level, pos, relay.getAvailableCharge());
        relay.input.compact();
        ItemStack stack = relay.getBurn();
        if (!stack.isEmpty()) {
            IItemEmcHolder emcHolder2 = (IItemEmcHolder)stack.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
            if (emcHolder2 != null) {
                long simulatedVal = relay.forceInsertEmc(emcHolder2.extractEmc(stack, relay.chargeRate, IEmcStorage.EmcAction.SIMULATE), IEmcStorage.EmcAction.SIMULATE);
                if (simulatedVal > 0L) {
                    relay.forceInsertEmc(emcHolder2.extractEmc(stack, simulatedVal, IEmcStorage.EmcAction.EXECUTE), IEmcStorage.EmcAction.EXECUTE);
                }
            } else {
                long emcVal = IEMCProxy.INSTANCE.getSellValue(stack);
                if (emcVal > 0L && emcVal <= relay.getNeededEmc()) {
                    relay.forceInsertEmc(emcVal, IEmcStorage.EmcAction.EXECUTE);
                    relay.getBurn().shrink(1);
                    relay.input.onContentsChanged(0);
                }
            }
        }
        if (relay.getStoredEmc() > 0L && (emcHolder = (IItemEmcHolder)(chargeable = relay.getCharging()).getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY)) != null) {
            long actualSent = emcHolder.insertEmc(chargeable, relay.getAvailableCharge(), IEmcStorage.EmcAction.EXECUTE);
            relay.forceExtractEmc(actualSent, IEmcStorage.EmcAction.EXECUTE);
        }
        relay.updateComparators(level, pos);
    }

    private long getAvailableCharge() {
        return Math.min(this.chargeRate, this.getStoredEmc());
    }

    public double getItemChargeProportion() {
        ItemStack charging = this.getCharging();
        IItemEmcHolder emcHolder = (IItemEmcHolder)charging.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
        if (emcHolder != null) {
            return (double)emcHolder.getStoredEmc(charging) / (double)emcHolder.getMaximumEmc(charging);
        }
        return 0.0;
    }

    public double getInputBurnProportion() {
        ItemStack burn = this.getBurn();
        if (burn.isEmpty()) {
            return 0.0;
        }
        IItemEmcHolder emcHolder = (IItemEmcHolder)burn.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
        if (emcHolder != null) {
            return (double)emcHolder.getStoredEmc(burn) / (double)emcHolder.getMaximumEmc(burn);
        }
        return (double)burn.getCount() / (double)burn.getMaxStackSize();
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.input.deserializeNBT(registries, tag.getCompound("input"));
        this.output.deserializeNBT(registries, tag.getCompound("output"));
        this.bonusEMC = tag.getDouble("bonus_emc");
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("input", (Tag)this.input.serializeNBT(registries));
        tag.put("output", (Tag)this.output.serializeNBT(registries));
        tag.putDouble("bonus_emc", this.bonusEMC);
    }

    @Override
    public double getBonusToAdd() {
        return 0.05;
    }

    @Override
    public void addBonus(@NotNull Level level, @NotNull BlockPos pos) {
        this.bonusEMC += this.getBonusToAdd();
        if (this.bonusEMC >= 1.0) {
            long emcToInsert = (long)this.bonusEMC;
            this.forceInsertEmc(emcToInsert, IEmcStorage.EmcAction.EXECUTE);
            this.bonusEMC -= (double)emcToInsert;
        }
        this.markDirty(level, pos, false);
    }

    @NotNull
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new RelayMK1Container(windowId, playerInventory, this);
    }

    @NotNull
    public Component getDisplayName() {
        return PELang.GUI_RELAY_MK1.translate();
    }
}

