/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import moze_intel.projecte.gameObjs.container.slots.HotBarSlot;
import moze_intel.projecte.gameObjs.container.slots.IInsertableSlot;
import moze_intel.projecte.gameObjs.container.slots.IInventoryContainerSlot;
import moze_intel.projecte.gameObjs.container.slots.MainInventorySlot;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.network.packets.IPEPacket;
import moze_intel.projecte.network.packets.to_client.container.UpdateWindowLongPKT;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PEContainer
extends AbstractContainerMenu {
    protected final List<IInventoryContainerSlot> inventoryContainerSlots = new ArrayList<IInventoryContainerSlot>();
    protected final List<MainInventorySlot> mainInventorySlots = new ArrayList<MainInventorySlot>();
    protected final List<HotBarSlot> hotBarSlots = new ArrayList<HotBarSlot>();
    protected final List<BoxedLong> longFields = new ArrayList<BoxedLong>();
    protected final Inventory playerInv;

    protected PEContainer(ContainerTypeRegistryObject<? extends PEContainer> typeRO, int id, Inventory playerInv) {
        super((MenuType)typeRO.get(), id);
        this.playerInv = playerInv;
    }

    protected void addPlayerInventory(int xStart, int yStart) {
        int i;
        int slotSize = 18;
        int rows = 3;
        for (i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(this.createMainInventorySlot(this.playerInv, j + i * 9 + 9, xStart + j * slotSize, yStart + i * slotSize));
            }
        }
        yStart = yStart + slotSize * rows + 4;
        for (i = 0; i < Inventory.getSelectionSize(); ++i) {
            this.addSlot(this.createHotBarSlot(this.playerInv, i, xStart + i * slotSize, yStart));
        }
    }

    protected MainInventorySlot createMainInventorySlot(@NotNull Inventory inv, int index, int x, int y) {
        return new MainInventorySlot((Container)inv, index, x, y);
    }

    protected HotBarSlot createHotBarSlot(@NotNull Inventory inv, int index, int x, int y) {
        return new HotBarSlot((Container)inv, index, x, y);
    }

    @NotNull
    protected Slot addSlot(@NotNull Slot slot) {
        super.addSlot(slot);
        Slot slot2 = slot;
        Objects.requireNonNull(slot2);
        Slot slot3 = slot2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IInventoryContainerSlot.class, MainInventorySlot.class, HotBarSlot.class}, (Object)slot3, n)) {
            case 0: {
                IInventoryContainerSlot containerSlot = (IInventoryContainerSlot)slot3;
                this.inventoryContainerSlots.add(containerSlot);
                break;
            }
            case 1: {
                MainInventorySlot inventorySlot = (MainInventorySlot)slot3;
                this.mainInventorySlots.add(inventorySlot);
                break;
            }
            case 2: {
                HotBarSlot hotBarSlot = (HotBarSlot)slot3;
                this.hotBarSlots.add(hotBarSlot);
                break;
            }
        }
        return slot;
    }

    @Nullable
    public Slot tryGetSlot(int slotId) {
        if (slotId >= 0 && slotId < this.slots.size()) {
            return this.getSlot(slotId);
        }
        return null;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotID) {
        ItemStack slotStack;
        Slot currentSlot = (Slot)this.slots.get(slotID);
        if (currentSlot == null || !currentSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackToInsert = slotStack = currentSlot.getItem();
        if (currentSlot instanceof IInventoryContainerSlot) {
            stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, true);
            stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, true);
            stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, false);
            stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, false);
        } else {
            stackToInsert = PEContainer.insertItem(this.inventoryContainerSlots(), stackToInsert, true);
            if (slotStack.getCount() == stackToInsert.getCount()) {
                stackToInsert = PEContainer.insertItem(this.inventoryContainerSlots(), stackToInsert, false);
                if (slotStack.getCount() == stackToInsert.getCount()) {
                    if (currentSlot instanceof MainInventorySlot) {
                        stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, true);
                        stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, false);
                    } else if (currentSlot instanceof HotBarSlot) {
                        stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, true);
                        stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, false);
                    }
                }
            }
        }
        if (stackToInsert.getCount() == slotStack.getCount()) {
            return ItemStack.EMPTY;
        }
        return this.transferSuccess(currentSlot, player, slotStack, stackToInsert);
    }

    private <SLOT extends Slot> List<SLOT> inventoryContainerSlots() {
        return this.inventoryContainerSlots;
    }

    @NotNull
    protected ItemStack transferSuccess(@NotNull Slot currentSlot, @NotNull Player player, @NotNull ItemStack slotStack, @NotNull ItemStack stackToInsert) {
        int difference = slotStack.getCount() - stackToInsert.getCount();
        ItemStack newStack = currentSlot.remove(difference);
        currentSlot.onTake(player, newStack);
        return newStack;
    }

    @NotNull
    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @NotNull ItemStack stack, boolean ignoreEmpty) {
        Slot slot;
        if (stack.isEmpty()) {
            return stack;
        }
        Iterator<SLOT> iterator = slots.iterator();
        while (iterator.hasNext() && (ignoreEmpty != (slot = (Slot)iterator.next()).hasItem() || !(stack = ((IInsertableSlot)slot).insertItem(stack, false)).isEmpty())) {
        }
        return stack;
    }

    public final void updateProgressBarLong(int idx, long data) {
        this.longFields.get(idx).set(data);
    }

    protected void broadcastPE(boolean all) {
        for (int i = 0; i < this.longFields.size(); ++i) {
            BoxedLong boxedLong = this.longFields.get(i);
            if (!boxedLong.isDirty() && !all) continue;
            this.syncDataChange(new UpdateWindowLongPKT((short)this.containerId, (short)i, boxedLong.get()));
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.broadcastPE(false);
    }

    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
        this.broadcastPE(true);
    }

    protected void syncDataChange(IPEPacket packet) {
        Player player = this.playerInv.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static class BoxedLong {
        private long inner;
        private boolean dirty = false;

        public long get() {
            return this.inner;
        }

        public void set(long v) {
            if (v != this.inner) {
                this.inner = v;
                this.dirty = true;
            }
        }

        public boolean isDirty() {
            boolean ret = this.dirty;
            this.dirty = false;
            return ret;
        }
    }
}

