/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.components.GemData;
import moze_intel.projecte.gameObjs.container.EternalDensityContainer;
import moze_intel.projecte.gameObjs.container.PEHandContainer;
import moze_intel.projecte.gameObjs.items.ICapabilityAware;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.IModeEnum;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GemEternalDensity
extends ItemPE
implements IAlchBagItem,
IAlchChestItem,
IItemMode<GemMode>,
ICapabilityAware {
    public GemEternalDensity(Item.Properties props) {
        super(props.component(PEDataComponentTypes.ACTIVE, (Object)false).component(PEDataComponentTypes.GEM_MODE, (Object)GemMode.IRON).component(PEDataComponentTypes.GEM_DATA, (Object)GemData.EMPTY).component(PEDataComponentTypes.STORED_EMC, (Object)0L));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            this.condense(stack, (IItemHandler)new PlayerMainInvWrapper(player.getInventory()));
        }
    }

    private boolean condense(ItemStack gem, IItemHandler inv) {
        if (!((Boolean)gem.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
            return false;
        }
        ItemLike target = ((GemMode)this.getMode(gem)).getTarget();
        long targetEmc = IEMCProxy.INSTANCE.getValue(target);
        if (targetEmc == 0L) {
            return false;
        }
        long gemEmc = (Long)gem.getOrDefault(PEDataComponentTypes.STORED_EMC, (Object)0L);
        if (gemEmc == Long.MAX_VALUE) {
            return this.condenseFromStoredEmc(inv, gem, gemEmc, target, targetEmc);
        }
        long emcRoomFor = Long.MAX_VALUE - gemEmc;
        GemData gemData = (GemData)gem.getOrDefault(PEDataComponentTypes.GEM_DATA, (Object)GemData.EMPTY);
        int slots = inv.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack copy;
            long emcValue;
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Boolean filtered = null;
            if (!stack.isStackable()) {
                if (!gemData.isWhitelist() || !gemData.whitelistMatches(stack)) continue;
                filtered = true;
            }
            if ((emcValue = IEMCProxy.INSTANCE.getValue(stack)) == 0L || emcValue >= targetEmc || emcValue > emcRoomFor) continue;
            long maxToAdd = emcRoomFor / emcValue;
            int halfStack = stack.getCount() == 1 ? 1 : stack.getCount() / 2;
            ItemStack simulatedExtraction = inv.extractItem(i, (int)Math.min(maxToAdd, (long)halfStack), true);
            if (simulatedExtraction.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)simulatedExtraction)) continue;
            if (filtered == null) {
                filtered = gemData.whitelistMatches(stack);
            }
            if (gemData.isWhitelist() != filtered.booleanValue() || (copy = inv.extractItem(i, simulatedExtraction.getCount(), false)).isEmpty()) continue;
            gem.set(PEDataComponentTypes.STORED_EMC, (Object)(gemEmc += emcValue * (long)copy.getCount()));
            gem.set(PEDataComponentTypes.GEM_DATA, (Object)gemData.addConsumed(copy));
            this.condenseFromStoredEmc(inv, gem, gemEmc, target, targetEmc);
            return true;
        }
        return this.condenseFromStoredEmc(inv, gem, gemEmc, target, targetEmc);
    }

    private boolean condenseFromStoredEmc(IItemHandler inv, ItemStack gem, long originalGemEmc, ItemLike target, long targetEmc) {
        if (originalGemEmc >= targetEmc) {
            ItemStack stackToInsert;
            ItemStack remaining;
            ItemStack targetStack = new ItemStack(target);
            int maxStackSize = targetStack.getMaxStackSize();
            long toInsert = originalGemEmc / targetEmc;
            long gemEmc = originalGemEmc;
            while (toInsert > 0L && (remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)(stackToInsert = targetStack.copyWithCount((int)Math.min(toInsert, (long)maxStackSize))), (boolean)false)).getCount() != stackToInsert.getCount()) {
                int inserted = stackToInsert.getCount() - remaining.getCount();
                toInsert -= (long)inserted;
                gemEmc -= targetEmc * (long)inserted;
            }
            if (gemEmc != originalGemEmc) {
                gem.set(PEDataComponentTypes.STORED_EMC, (Object)gemEmc);
                gem.update(PEDataComponentTypes.GEM_DATA, (Object)GemData.EMPTY, GemData::clearConsumed);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (player.isSecondaryUseActive()) {
                if (((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
                    GemData oldData = (GemData)stack.update(PEDataComponentTypes.GEM_DATA, (Object)GemData.EMPTY, GemData::clearConsumed);
                    if (oldData != null && !oldData.consumed().isEmpty()) {
                        WorldHelper.createLootDrop(oldData.consumed(), level, player.position());
                        stack.set(PEDataComponentTypes.STORED_EMC, (Object)0L);
                    }
                    stack.set(PEDataComponentTypes.ACTIVE, (Object)false);
                } else {
                    stack.set(PEDataComponentTypes.ACTIVE, (Object)true);
                }
            } else {
                int selected = player.getInventory().selected;
                player.openMenu((MenuProvider)new ContainerProvider(hand, selected), buf -> {
                    buf.writeEnum((Enum)hand);
                    buf.writeByte(selected);
                });
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public DataComponentType<GemMode> getDataComponentType() {
        return (DataComponentType)PEDataComponentTypes.GEM_MODE.get();
    }

    @Override
    public GemMode getDefaultMode() {
        return GemMode.IRON;
    }

    @Override
    public ILangEntry getModeSwitchEntry() {
        return PELang.DENSITY_MODE_TARGET;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        MutableComponent interact = Component.keybind((String)"key.use");
        tooltip.add((Component)PELang.TOOLTIP_GEM_DENSITY_1.translate());
        tooltip.add((Component)PELang.TOOLTIP_GEM_DENSITY_2.translate(this.getMode(stack)));
        tooltip.add((Component)PELang.TOOLTIP_GEM_DENSITY_3.translate(ClientKeyHelper.getKeyName(PEKeybind.MODE)));
        tooltip.add((Component)PELang.TOOLTIP_GEM_DENSITY_4.translate(interact));
        tooltip.add((Component)PELang.TOOLTIP_GEM_DENSITY_5.translate(Component.keybind((String)"key.sneak"), interact));
    }

    @Override
    public boolean updateInAlchChest(@NotNull Level level, @NotNull BlockPos pos, @NotNull ItemStack stack) {
        if (!level.isClientSide && ((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
            IItemHandler handler = (IItemHandler)WorldHelper.getCapability(level, Capabilities.ItemHandler.BLOCK, pos, null);
            return handler != null && this.condense(stack, handler);
        }
        return false;
    }

    @Override
    public boolean updateInAlchBag(@NotNull IItemHandler inv, @NotNull Player player, @NotNull ItemStack stack) {
        return !player.level().isClientSide && this.condense(stack, inv);
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        IntegrationHelper.registerCuriosCapability(event, this);
    }

    public static enum GemMode implements IModeEnum<GemMode>
    {
        IRON((ItemLike)Items.IRON_INGOT),
        GOLD((ItemLike)Items.GOLD_INGOT),
        DIAMOND((ItemLike)Items.DIAMOND),
        DARK_MATTER(PEItems.DARK_MATTER),
        RED_MATTER(PEItems.RED_MATTER);

        public static final Codec<GemMode> CODEC;
        public static final IntFunction<GemMode> BY_ID;
        public static final StreamCodec<ByteBuf, GemMode> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final ItemLike target;

        private GemMode(ItemLike target) {
            this.target = target;
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        @Override
        public String getTranslationKey() {
            return this.target.asItem().getDescriptionId();
        }

        public ItemLike getTarget() {
            return this.target;
        }

        @Override
        public GemMode next(ItemStack stack) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> GOLD;
                case 1 -> DIAMOND;
                case 2 -> DARK_MATTER;
                case 3 -> RED_MATTER;
                case 4 -> IRON;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(GemMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])GemMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    private record ContainerProvider(InteractionHand hand, int selected) implements MenuProvider
    {
        @Nullable
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
            if (PEHandContainer.getStack(playerInventory, this.hand, this.selected).getItem() instanceof GemEternalDensity) {
                return new EternalDensityContainer(windowId, playerInventory, this.hand, playerInventory.selected);
            }
            return null;
        }

        @NotNull
        public Component getDisplayName() {
            return TextComponentUtil.build(PEItems.GEM_OF_ETERNAL_DENSITY.get());
        }
    }
}

