/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.ICapabilityAware;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class BodyStone
extends PEToggleItem
implements IPedestalItem,
ICapabilityAware {
    public BodyStone(Item.Properties props) {
        super(props.component(PEDataComponentTypes.STORED_EMC, (Object)0L));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (level.isClientSide || !BodyStone.hotBarOrOffHand(slot) || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
            if (BodyStone.consumeFuel(player, stack, 64L, false)) {
                if (PlayerHelper.checkFeedCooldown(player)) {
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.HEAL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.getFoodData().eat(2, 10.0f);
                    player.gameEvent((Holder)GameEvent.EAT);
                    BodyStone.removeEmc(stack, 64L);
                }
            } else {
                stack.set(PEDataComponentTypes.ACTIVE, (Object)false);
            }
        }
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.isClientSide && ProjectEConfig.server.cooldown.pedestal.body.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, ((IDMPedestal)pedestal).getEffectBounds())) {
                    if (!player.getFoodData().needsFood()) continue;
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.HEAL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.getFoodData().eat(1, 1.0f);
                }
                ((IDMPedestal)pedestal).setActivityCooldown(level, pos, ProjectEConfig.server.cooldown.pedestal.body.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown(level, pos);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.body.get() != -1) {
            list.add((Component)PELang.PEDESTAL_BODY_STONE_1.translateColored(ChatFormatting.BLUE));
            list.add((Component)PELang.PEDESTAL_BODY_STONE_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.body.get(), tickRate)));
        }
        return list;
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        IntegrationHelper.registerCuriosCapability(event, this);
    }
}

