/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.SpecialPlantable;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import org.jetbrains.annotations.NotNull;

public class HarvestGoddess
extends PEToggleItem
implements IPedestalItem {
    public HarvestGoddess(Item.Properties props) {
        super(props.component(PEDataComponentTypes.STORED_EMC, (Object)0L).component(PEDataComponentTypes.UNPROCESSED_EMC, (Object)0.0));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (level.isClientSide || !HarvestGoddess.hotBarOrOffHand(slot) || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
            if (!HarvestGoddess.hasEmc(player, stack, 64L, true)) {
                stack.set(PEDataComponentTypes.ACTIVE, (Object)false);
            } else {
                WorldHelper.growNearbyRandomly(true, level, player);
                HarvestGoddess.removeEmc(stack, 0.32f);
            }
        } else {
            WorldHelper.growNearbyRandomly(false, level, player);
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        BlockPos pos = ctx.getClickedPos();
        Direction side = ctx.getClickedFace();
        if (player == null || !player.mayUseItemAt(pos, side, ctx.getItemInHand())) {
            return InteractionResult.FAIL;
        }
        if (ctx.isSecondaryUseActive()) {
            for (ItemStack stack : player.getInventory().items) {
                InteractionResult result;
                if (!stack.is(Items.BONE_MEAL) || (result = this.useBoneMeal(level, pos, side, player, stack)) == InteractionResult.PASS) continue;
                return result;
            }
        } else if (this.plantSeeds(level, player, pos)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult useBoneMeal(Level level, BlockPos pos, Direction side, Player player, ItemStack stack) {
        int count = stack.getCount();
        if (count < 4) {
            return InteractionResult.PASS;
        }
        int successfulTargets = 0;
        for (BlockPos currentPos : WorldHelper.horizontalPositionsAround(pos, 15)) {
            boolean wasSuccessful = false;
            BlockState state = level.getBlockState(currentPos);
            BonemealEvent event = EventHooks.fireBonemealEvent((Player)player, (Level)level, (BlockPos)currentPos, (BlockState)state, (ItemStack)stack);
            if (event.isCanceled()) {
                wasSuccessful = event.isSuccessful();
            } else if (event.isValidBonemealTarget()) {
                wasSuccessful = true;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    BonemealableBlock growable = (BonemealableBlock)state.getBlock();
                    if (growable.isBonemealSuccess(level, level.random, currentPos, state)) {
                        growable.performBonemeal(serverLevel, level.random, currentPos, state);
                        player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                        level.levelEvent(1505, currentPos, 0);
                    }
                }
            }
            if (wasSuccessful) {
                ++successfulTargets;
                continue;
            }
            BlockPos posAgainst = currentPos.relative(side.getOpposite());
            if (!level.getBlockState(posAgainst).isFaceSturdy((BlockGetter)level, posAgainst, side) || !BoneMealItem.growWaterPlant((ItemStack)ItemStack.EMPTY, (Level)level, (BlockPos)currentPos, (Direction)side)) continue;
            ++successfulTargets;
            if (level.isClientSide) break;
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
            level.levelEvent(1505, currentPos, 0);
        }
        if (!level.isClientSide) {
            int alreadyRemoved = count - stack.getCount();
            if (alreadyRemoved >= 0 && alreadyRemoved <= 4) {
                stack.shrink(Math.min(4 - alreadyRemoved, successfulTargets));
            }
            if (stack.getCount() != count) {
                player.inventoryMenu.broadcastChanges();
            }
        }
        return successfulTargets == 0 ? InteractionResult.FAIL : InteractionResult.CONSUME;
    }

    private boolean plantSeeds(Level level, Player player, BlockPos pos) {
        List<ItemStack> seeds = this.getAllSeeds((NonNullList<ItemStack>)player.getInventory().items);
        if (seeds.isEmpty()) {
            return false;
        }
        boolean hasPlantedAny = false;
        block0: for (BlockPos currentPos : WorldHelper.horizontalPositionsAround(pos, 8)) {
            BlockState state = level.getBlockState(currentPos);
            if (state.isAir()) continue;
            BlockPos plantPos = currentPos.above();
            BlockPlaceContext placeContext = null;
            Iterator<ItemStack> iterator = seeds.iterator();
            while (iterator.hasNext()) {
                ItemStack stack = iterator.next();
                boolean planted = false;
                Item item = stack.getItem();
                if (item instanceof SpecialPlantable) {
                    SpecialPlantable plantable = (SpecialPlantable)item;
                    if (plantable.canPlacePlantAtPosition(stack, (LevelReader)level, plantPos, Direction.DOWN)) {
                        plantable.spawnPlantAtPosition(stack, (LevelAccessor)level, plantPos, Direction.DOWN);
                        planted = true;
                    }
                } else if (stack.is(PETags.Items.PLANTABLE_SEEDS) && (item = stack.getItem()) instanceof BlockItem) {
                    BlockState plantState;
                    BlockItem blockItem = (BlockItem)item;
                    if (placeContext == null) {
                        placeContext = new BlockPlaceContext(level, player, InteractionHand.MAIN_HAND, stack, new BlockHitResult(currentPos.getCenter().relative(Direction.UP, 0.5), Direction.UP, currentPos, false));
                        placeContext.replaceClicked = false;
                    }
                    if (placeContext.canPlace() && (plantState = blockItem.getPlacementState(placeContext)) != null) {
                        level.setBlockAndUpdate(plantPos, plantState);
                        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, plantPos, GameEvent.Context.of((Entity)player, (BlockState)plantState));
                        planted = true;
                    }
                }
                if (!planted) continue;
                hasPlantedAny = true;
                stack.shrink(1);
                player.inventoryMenu.broadcastChanges();
                if (!stack.isEmpty()) continue block0;
                iterator.remove();
                if (!seeds.isEmpty()) continue block0;
                return hasPlantedAny;
            }
        }
        return hasPlantedAny;
    }

    private List<ItemStack> getAllSeeds(NonNullList<ItemStack> inv) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : inv) {
            Item item;
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof SpecialPlantable) && (!stack.is(PETags.Items.PLANTABLE_SEEDS) || !(item instanceof BlockItem))) continue;
            result.add(stack);
        }
        return result;
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.isClientSide && ProjectEConfig.server.cooldown.pedestal.harvest.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                WorldHelper.growNearbyRandomly(true, level, ((IDMPedestal)pedestal).getEffectBounds(), null);
                ((IDMPedestal)pedestal).setActivityCooldown(level, pos, ProjectEConfig.server.cooldown.pedestal.harvest.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown(level, pos);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.harvest.get() != -1) {
            list.add((Component)PELang.PEDESTAL_HARVEST_GODDESS_1.translateColored(ChatFormatting.BLUE));
            list.add((Component)PELang.PEDESTAL_HARVEST_GODDESS_2.translateColored(ChatFormatting.BLUE));
            list.add((Component)PELang.PEDESTAL_HARVEST_GODDESS_3.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.harvest.get(), tickRate)));
        }
        return list;
    }
}

