/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl.codec;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.codec.MapProcessor;

public record PEUnboundedMapCodec<KEY, VALUE, MAP extends Map<KEY, VALUE>>(MapCodec<KEY> keyCodec, MapCodec<VALUE> valueCodec, MapProcessor<KEY, VALUE> processor, boolean lenientKey, Supplier<? extends MAP> elementReaderCreator, UnaryOperator<MAP> makeImmutable) implements Codec<MAP>
{
    public PEUnboundedMapCodec {
        PEUnboundedMapCodec.validateCodecKeys(JsonOps.INSTANCE, keyCodec, valueCodec);
    }

    private static <T> void validateCodecKeys(DynamicOps<T> ops, MapCodec<?> keyCodec, MapCodec<?> valueCodec) {
        Set keyCodecKeys = keyCodec.keys(ops).collect(Collectors.toSet());
        if (!keyCodecKeys.isEmpty()) {
            String overlappingKeys = valueCodec.keys(ops).filter(keyCodecKeys::contains).map(arg_0 -> ops.getStringValue(arg_0)).filter(DataResult::isSuccess).map(DataResult::getOrThrow).collect(Collectors.joining(", "));
            if (!overlappingKeys.isEmpty()) {
                throw new IllegalArgumentException("Keys and Values for unbounded maps cannot have overlapping keys: " + overlappingKeys);
            }
        }
    }

    public static <KEY, VALUE> PEUnboundedMapCodec<KEY, VALUE, Map<KEY, VALUE>> create(MapCodec<KEY> keyCodec, MapCodec<VALUE> valueCodec, MapProcessor<KEY, VALUE> processor, boolean lenientKey) {
        return new PEUnboundedMapCodec<KEY, VALUE, Map>(keyCodec, valueCodec, processor, lenientKey, LinkedHashMap::new, ImmutableMap::copyOf);
    }

    public <T> DataResult<T> encode(MAP input, DynamicOps<T> ops, T prefix) {
        ListBuilder builder = ops.listBuilder();
        for (Map.Entry entry : input.entrySet()) {
            RecordBuilder encoded = this.keyCodec().encode(entry.getKey(), ops, ops.mapBuilder());
            encoded = this.valueCodec().encode(entry.getValue(), ops, encoded);
            builder.add(encoded.build(ops.emptyMap()));
        }
        return builder.build(prefix);
    }

    public <T> DataResult<Pair<MAP, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
            DecoderState decoder = new DecoderState(ops);
            stream.accept(decoder::accept);
            return decoder.build();
        }).map(result -> Pair.of((Object)result, (Object)input));
    }

    @Override
    public String toString() {
        if (this.lenientKey) {
            return "projecte:LenientKeyUnboundedMapCodec[" + String.valueOf(this.keyCodec) + " -> " + String.valueOf(this.valueCodec) + "]";
        }
        return "projecte:UnboundedMapCodec[" + String.valueOf(this.keyCodec) + " -> " + String.valueOf(this.valueCodec) + "]";
    }

    private class DecoderState<T> {
        private static final DataResult<Unit> INITIAL_RESULT = DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable());
        private final DynamicOps<T> ops;
        private final MAP elements;
        private final Stream.Builder<T> failed;
        private DataResult<Unit> result;

        private DecoderState(DynamicOps<T> ops) {
            this.elements = (Map)PEUnboundedMapCodec.this.elementReaderCreator.get();
            this.failed = Stream.builder();
            this.result = INITIAL_RESULT;
            this.ops = ops;
        }

        private void accept(T input) {
            DataResult keyResult = PEUnboundedMapCodec.this.keyCodec().decoder().parse(this.ops, input);
            if (PEUnboundedMapCodec.this.lenientKey() && keyResult.isError()) {
                PECore.LOGGER.error("Unable to deserialize key: {}", (Object)((DataResult.Error)keyResult.error().orElseThrow()).message());
                return;
            }
            DataResult valueResult = PEUnboundedMapCodec.this.valueCodec().decoder().parse(this.ops, input);
            DataResult entryResult = keyResult.apply2stable(Map::entry, valueResult);
            Optional resultOrPartial = entryResult.resultOrPartial();
            if (resultOrPartial.isPresent()) {
                Map.Entry entry = (Map.Entry)resultOrPartial.get();
                Object existing = PEUnboundedMapCodec.this.processor().addElement(this.elements, entry.getKey(), entry.getValue());
                if (existing != null) {
                    this.failed.add(input);
                    this.result = this.result.apply2stable((result, element) -> result, DataResult.error(() -> "Duplicate entry for key: '" + String.valueOf(entry.getKey()) + "'"));
                    return;
                }
            }
            entryResult.ifError(error -> this.failed.add(input));
            this.result = this.result.apply2stable((result, element) -> result, entryResult);
        }

        public DataResult<MAP> build() {
            Object errors = this.ops.createList(this.failed.build());
            Map immutableElements = (Map)PEUnboundedMapCodec.this.makeImmutable.apply(this.elements);
            return this.result.map(ignored -> immutableElements).setPartial((Object)immutableElements).mapError(e -> e + " missed input: " + String.valueOf(errors));
        }
    }
}

