/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker.nss;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.serialization.DynamicOps;
import moze_intel.projecte.api.codec.IPECodecHelper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/ProjectE/NSSResolver")
@ZenCodeType.Name(value="mods.projecte.NSSResolver")
public class CrTNSSResolver {
    private CrTNSSResolver() {
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack deserialize(MapData representation) {
        return (NormalizedSimpleStack)IPECodecHelper.INSTANCE.nssCodec().parse((DynamicOps)IDataOps.INSTANCE.withRegistryAccess(), (Object)representation).getOrThrow(error -> new IllegalArgumentException("Error deserializing NSS representation: " + error));
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack fromItem(Item item) {
        if (item == Items.AIR) {
            throw new IllegalArgumentException("Cannot make an NSS Representation from the empty item.");
        }
        return NSSItem.createItem((ItemLike)item);
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack fromItem(IItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Cannot make an NSS Representation from an empty item stack.");
        }
        return NSSItem.createItem(stack.getInternal());
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack fromItemTag(KnownTag<Item> tag) {
        if (tag.exists()) {
            return NSSItem.createTag(tag.id());
        }
        throw new IllegalArgumentException("Item tag " + tag.getCommandString() + " does not exist.");
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack fromFluid(IFluidStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Cannot make an NSS Representation from an empty fluid stack.");
        }
        return NSSFluid.createFluid((FluidStack)stack.getInternal());
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack fromFluid(Fluid fluid) {
        if (fluid == Fluids.EMPTY) {
            throw new IllegalArgumentException("Cannot make an NSS Representation from the empty fluid.");
        }
        return NSSFluid.createFluid(fluid);
    }

    @ZenCodeType.Method
    public static NormalizedSimpleStack fromFluidTag(KnownTag<Fluid> tag) {
        if (tag.exists()) {
            return NSSFluid.createTag(tag.id());
        }
        throw new IllegalArgumentException("Fluid tag " + tag.getCommandString() + " does not exist.");
    }
}

