/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.recipe_viewer.jei;

import com.mojang.serialization.Codec;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.integration.recipe_viewer.FuelUpgradeRecipe;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CollectorRecipeCategory
implements IRecipeCategory<FuelUpgradeRecipe> {
    public static final RecipeType<FuelUpgradeRecipe> RECIPE_TYPE = new RecipeType(PECore.rl("collector"), FuelUpgradeRecipe.class);
    private final IDrawable icon;

    public CollectorRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(PEBlocks.COLLECTOR));
    }

    @NotNull
    public RecipeType<FuelUpgradeRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return PELang.JEI_COLLECTOR.translate();
    }

    public ResourceLocation getRegistryName(FuelUpgradeRecipe recipe) {
        return recipe.syntheticId();
    }

    public int getWidth() {
        return 80;
    }

    public int getHeight() {
        return 36;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull FuelUpgradeRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 16).addItemStack(new ItemStack(recipe.input()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 16).addItemStack(new ItemStack(recipe.output()));
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, @NotNull FuelUpgradeRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addRecipeArrow().setPosition(27, 16);
        ((ITextWidget)builder.addText((FormattedText)PELang.EMC.translate(recipe.upgradeEMC()), this.getWidth() - 10, 11).setPosition(5, 5)).setTextAlignment(HorizontalAlignment.CENTER);
    }

    @NotNull
    public Codec<FuelUpgradeRecipe> getCodec(@NotNull ICodecHelper codecHelper, @NotNull IRecipeManager recipeManager) {
        return FuelUpgradeRecipe.CODEC;
    }
}

