/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main.events;

import com.dooji.underlay.main.UnderlayApi;
import com.dooji.underlay.main.UnderlayManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class BlockInteractionEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handleOverlayPlacement(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ItemStack stack = event.getItemStack();
        if (!(stack.getItem() instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)stack.getItem();
        Block block = blockItem.getBlock();
        Direction face = event.getFace();
        BlockPos clickedPos = event.getPos();
        if (face != Direction.UP) {
            return;
        }
        BlockPos targetPos = clickedPos.above();
        ServerLevel world = (ServerLevel)event.getLevel();
        BlockPlaceContext context = new BlockPlaceContext(new UseOnContext((Player)player, event.getHand(), event.getHitVec()));
        BlockState newState = block.getStateForPlacement(context);
        BlockState existingState = world.getBlockState(targetPos);
        if (newState != null && existingState.getBlock() == block && newState.getBlock() == block) {
            return;
        }
        if (!UnderlayApi.isOverlayBlock(block)) {
            return;
        }
        if (existingState.isAir()) {
            return;
        }
        if (Block.isShapeFullBlock((VoxelShape)existingState.getShape((BlockGetter)world, targetPos))) {
            return;
        }
        if (!existingState.getFluidState().isEmpty()) {
            return;
        }
        if (!world.mayInteract((Player)player, targetPos)) {
            return;
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
        UnderlayManager.addOverlay(player, (Level)world, targetPos, newState);
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        SoundType sound = newState.getSoundType();
        world.playSound((Player)player, targetPos, sound.getPlaceSound(), SoundSource.BLOCKS, sound.getVolume(), sound.getPitch());
    }
}

