/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.mixin;

import com.dooji.underlay.client.UnderlayManagerClient;
import com.dooji.underlay.client.UnderlayRaycast;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.jade.impl.BlockAccessorImpl;

@Pseudo
@Mixin(value={BlockAccessorImpl.class}, remap=false)
public class JadeBlockAccessorImplMixin {
    @Inject(method={"getBlockState"}, at={@At(value="RETURN")}, cancellable=true)
    private void getOverlayBlockState(CallbackInfoReturnable<BlockState> cir) {
        BlockState overlayState;
        float tickDelta;
        double reach;
        BlockHitResult hit;
        BlockAccessorImpl self = (BlockAccessorImpl)this;
        BlockPos pos = self.getPosition();
        Minecraft client = Minecraft.getInstance();
        if (client.player != null && client.level != null && (hit = UnderlayRaycast.trace((Entity)client.player, reach = 4.5, tickDelta = (float)(client.getFrameTimeNs() / 50000000L))) != null && hit.getBlockPos().equals((Object)pos) && (overlayState = UnderlayManagerClient.getOverlay(pos)) != null) {
            cir.setReturnValue((Object)overlayState);
        }
    }

    @Inject(method={"getBlock"}, at={@At(value="RETURN")}, cancellable=true)
    private void getOverlayBlock(CallbackInfoReturnable<Block> cir) {
        BlockState overlayState;
        float tickDelta;
        double reach;
        BlockHitResult hit;
        BlockAccessorImpl self = (BlockAccessorImpl)this;
        BlockPos pos = self.getPosition();
        Minecraft client = Minecraft.getInstance();
        if (client.player != null && client.level != null && (hit = UnderlayRaycast.trace((Entity)client.player, reach = 4.5, tickDelta = (float)(client.getFrameTimeNs() / 50000000L))) != null && hit.getBlockPos().equals((Object)pos) && (overlayState = UnderlayManagerClient.getOverlay(pos)) != null) {
            cir.setReturnValue((Object)overlayState.getBlock());
        }
    }

    @Inject(method={"getPickedResult"}, at={@At(value="RETURN")}, cancellable=true)
    private void getOverlayPickedResult(CallbackInfoReturnable<ItemStack> cir) {
        Item overlayItem;
        BlockState overlayState;
        float tickDelta;
        double reach;
        BlockHitResult hit;
        BlockAccessorImpl self = (BlockAccessorImpl)this;
        BlockPos pos = self.getPosition();
        Minecraft client = Minecraft.getInstance();
        if (client.player != null && client.level != null && (hit = UnderlayRaycast.trace((Entity)client.player, reach = 4.5, tickDelta = (float)(client.getFrameTimeNs() / 50000000L))) != null && hit.getBlockPos().equals((Object)pos) && (overlayState = UnderlayManagerClient.getOverlay(pos)) != null && (overlayItem = overlayState.getBlock().asItem()) != Items.AIR) {
            cir.setReturnValue((Object)new ItemStack((ItemLike)overlayItem));
        }
    }

    @Inject(method={"getFakeBlock"}, at={@At(value="RETURN")}, cancellable=true)
    private void getOverlayFakeBlock(CallbackInfoReturnable<ItemStack> cir) {
        BlockState overlayState;
        float tickDelta;
        double reach;
        BlockHitResult hit;
        BlockAccessorImpl self = (BlockAccessorImpl)this;
        BlockPos pos = self.getPosition();
        Minecraft client = Minecraft.getInstance();
        if (client.player != null && client.level != null && (hit = UnderlayRaycast.trace((Entity)client.player, reach = 4.5, tickDelta = (float)(client.getFrameTimeNs() / 50000000L))) != null && hit.getBlockPos().equals((Object)pos) && (overlayState = UnderlayManagerClient.getOverlay(pos)) != null && overlayState.getBlock().asItem() instanceof BlockItem) {
            cir.setReturnValue((Object)new ItemStack((ItemLike)overlayState.getBlock().asItem()));
        }
    }
}

